import _sodium from "libsodium-wrappers";
import { Rollsum } from "./Chunker";
export declare const sodium: typeof _sodium;
export declare function _setRnSodium(rnsodium_: any): void;
export declare const ready: Promise<void>;
export declare function concatArrayBuffers(buffer1: Uint8Array, buffer2: Uint8Array): Uint8Array;
export declare function concatArrayBuffersArrays(buffers: Uint8Array[]): Uint8Array;
export declare function deriveKey(salt: Uint8Array, password: string): Promise<Uint8Array>;
export declare class CryptoManager {
    protected version: number;
    protected cipherKey: Uint8Array;
    protected macKey: Uint8Array;
    protected asymKeySeed: Uint8Array;
    protected subDerivationKey: Uint8Array;
    protected determinsticEncryptionKey: Uint8Array;
    constructor(key: Uint8Array, keyContext: string, version?: number);
    encrypt(message: Uint8Array, additionalData?: Uint8Array | null): Uint8Array;
    decrypt(nonceCiphertext: Uint8Array, additionalData?: Uint8Array | null): Uint8Array;
    encryptDetached(message: Uint8Array, additionalData?: Uint8Array | null): [Uint8Array, Uint8Array];
    decryptDetached(nonceCiphertext: Uint8Array, mac: Uint8Array, additionalData?: Uint8Array | null): Uint8Array;
    verify(nonceCiphertext: Uint8Array, mac: Uint8Array, additionalData?: Uint8Array | null): boolean;
    deterministicEncrypt(message: Uint8Array, additionalData?: Uint8Array | null): Uint8Array;
    deterministicDecrypt(nonceCiphertext: Uint8Array, additionalData?: Uint8Array | null): Uint8Array;
    deriveSubkey(salt: Uint8Array): Uint8Array;
    getCryptoMac(withKey?: boolean): CryptoMac;
    calculateMac(message: Uint8Array, withKey?: boolean): Uint8Array;
    getChunker(): Rollsum;
}
export declare class LoginCryptoManager {
    private keypair;
    private constructor();
    static keygen(seed: Uint8Array): LoginCryptoManager;
    signDetached(message: Uint8Array): Uint8Array;
    static verifyDetached(message: Uint8Array, signature: Uint8Array, pubkey: Uint8Array): boolean;
    get pubkey(): Uint8Array;
}
export declare class BoxCryptoManager {
    private keypair;
    private constructor();
    static keygen(seed?: Uint8Array): BoxCryptoManager;
    static fromPrivkey(privkey: Uint8Array): BoxCryptoManager;
    encrypt(message: Uint8Array, pubkey: Uint8Array): Uint8Array;
    decrypt(nonceCiphertext: Uint8Array, pubkey: Uint8Array): Uint8Array;
    get pubkey(): Uint8Array;
    get privkey(): Uint8Array;
}
export declare class CryptoMac {
    private state;
    private length;
    constructor(key: Uint8Array | null, length?: number);
    updateWithLenPrefix(messageChunk: Uint8Array): void;
    update(messageChunk: Uint8Array): void;
    finalize(): Uint8Array;
}
export declare function getPrettyFingerprint(content: Uint8Array, delimiter?: string): string;
