"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProgrammingError = exports.ServerError = exports.TemporaryServerError = exports.NotFoundError = exports.ConflictError = exports.PermissionDeniedError = exports.UnauthorizedError = exports.MissingContentError = exports.IntegrityError = exports.NetworkError = exports.HttpError = void 0;
class ExtendableError extends Error {
    constructor(message) {
        super(message);
        Object.setPrototypeOf(this, ExtendableError.prototype);
        this.name = "ExtendableError";
        this.stack = (new Error(message)).stack;
    }
}
class HttpError extends ExtendableError {
    constructor(status, message, content) {
        super(`${status} ${message}`);
        Object.setPrototypeOf(this, HttpError.prototype);
        this.name = "HTTPError";
        this.status = status;
        this.content = content;
    }
}
exports.HttpError = HttpError;
class NetworkError extends ExtendableError {
    constructor(message) {
        super(message);
        Object.setPrototypeOf(this, NetworkError.prototype);
        this.name = "NetworkError";
    }
}
exports.NetworkError = NetworkError;
class IntegrityError extends ExtendableError {
    constructor(message) {
        super(message);
        Object.setPrototypeOf(this, IntegrityError.prototype);
        this.name = "IntegrityError";
    }
}
exports.IntegrityError = IntegrityError;
class MissingContentError extends ExtendableError {
    constructor(message) {
        super(message);
        Object.setPrototypeOf(this, MissingContentError.prototype);
        this.name = "MissingContentError";
    }
}
exports.MissingContentError = MissingContentError;
class UnauthorizedError extends ExtendableError {
    constructor(message, content) {
        super(message);
        Object.setPrototypeOf(this, UnauthorizedError.prototype);
        this.name = "UnauthorizedError";
        this.content = content;
    }
}
exports.UnauthorizedError = UnauthorizedError;
class PermissionDeniedError extends ExtendableError {
    constructor(message) {
        super(message);
        Object.setPrototypeOf(this, PermissionDeniedError.prototype);
        this.name = "PermissionDeniedError";
    }
}
exports.PermissionDeniedError = PermissionDeniedError;
class ConflictError extends ExtendableError {
    constructor(message) {
        super(message);
        Object.setPrototypeOf(this, ConflictError.prototype);
        this.name = "ConflictError";
    }
}
exports.ConflictError = ConflictError;
class NotFoundError extends ExtendableError {
    constructor(message) {
        super(message);
        Object.setPrototypeOf(this, NotFoundError.prototype);
        this.name = "NotFoundError";
    }
}
exports.NotFoundError = NotFoundError;
class TemporaryServerError extends HttpError {
    constructor(status, message, content) {
        super(status, message, content);
        Object.setPrototypeOf(this, TemporaryServerError.prototype);
        this.name = "TemporaryServerError";
    }
}
exports.TemporaryServerError = TemporaryServerError;
class ServerError extends HttpError {
    constructor(status, message, content) {
        super(status, message, content);
        Object.setPrototypeOf(this, ServerError.prototype);
        this.name = "ServerError";
    }
}
exports.ServerError = ServerError;
class ProgrammingError extends ExtendableError {
    constructor(message) {
        super(message);
        Object.setPrototypeOf(this, ProgrammingError.prototype);
        this.name = "ProgrammingError";
    }
}
exports.ProgrammingError = ProgrammingError;
//# sourceMappingURL=Exceptions.js.map