declare class ExtendableError extends Error {
    constructor(message: any);
}
export interface HttpFieldErrors {
    code: string;
    detail: string;
    field?: string;
}
export interface HttpErrorContent {
    code?: string;
    detail?: string;
    errors?: HttpFieldErrors[];
}
export declare class HttpError extends ExtendableError {
    status: number;
    content?: HttpErrorContent;
    constructor(status: number, message: any, content?: HttpErrorContent);
}
export declare class NetworkError extends ExtendableError {
    constructor(message: any);
}
export declare class IntegrityError extends ExtendableError {
    constructor(message: any);
}
export declare class MissingContentError extends ExtendableError {
    constructor(message: any);
}
export declare class UnauthorizedError extends ExtendableError {
    content?: HttpErrorContent;
    constructor(message: any, content?: HttpErrorContent);
}
export declare class PermissionDeniedError extends ExtendableError {
    constructor(message: any);
}
export declare class ConflictError extends ExtendableError {
    constructor(message: any);
}
export declare class NotFoundError extends ExtendableError {
    constructor(message: any);
}
export declare class TemporaryServerError extends HttpError {
    constructor(status: number, message: any, content?: HttpErrorContent);
}
export declare class ServerError extends HttpError {
    constructor(status: number, message: any, content?: HttpErrorContent);
}
export declare class ProgrammingError extends ExtendableError {
    constructor(message: any);
}
export {};
