import { CryptoManager, BoxCryptoManager, LoginCryptoManager } from "./Crypto";
import { base64 } from "./Helpers";
export declare type CollectionType = string;
export declare type ContentType = File | Blob | Uint8Array | string | null;
export declare type ItemMetadata<T = {}> = {
    type?: string;
    name?: string;
    mtime?: number;
    description?: string;
    color?: string;
} & T;
export declare type ChunkJson = [base64, Uint8Array?];
export interface CollectionItemRevisionJsonWrite {
    uid: base64;
    meta: Uint8Array;
    chunks: ChunkJson[];
    deleted: boolean;
}
export declare type CollectionItemRevisionJsonRead = CollectionItemRevisionJsonWrite;
export interface CollectionItemJsonWrite {
    uid: base64;
    version: number;
    encryptionKey?: Uint8Array;
    content: CollectionItemRevisionJsonWrite;
    etag: string | null;
}
export declare type CollectionItemJsonRead = CollectionItemJsonWrite;
export declare enum CollectionAccessLevel {
    ReadOnly = 0,
    Admin = 1,
    ReadWrite = 2
}
export interface CollectionJsonWrite {
    collectionKey: Uint8Array;
    item: CollectionItemJsonWrite;
    collectionType: Uint8Array;
}
export interface CollectionJsonRead extends CollectionJsonWrite {
    accessLevel: CollectionAccessLevel;
    stoken: string | null;
    item: CollectionItemJsonRead;
}
export interface SignedInvitationWrite {
    uid: base64;
    version: number;
    username: string;
    collection: base64;
    accessLevel: CollectionAccessLevel;
    signedEncryptionKey: Uint8Array;
}
export interface SignedInvitationRead extends SignedInvitationWrite {
    fromUsername?: string;
    fromPubkey: Uint8Array;
}
export declare class MainCryptoManager extends CryptoManager {
    protected Main: boolean;
    constructor(key: Uint8Array, version?: number);
    getLoginCryptoManager(): LoginCryptoManager;
    getAccountCryptoManager(privkey: Uint8Array): AccountCryptoManager;
    getIdentityCryptoManager(privkey: Uint8Array): BoxCryptoManager;
}
export declare class AccountCryptoManager extends CryptoManager {
    protected Account: boolean;
    private colTypePadSize;
    constructor(key: Uint8Array, version?: number);
    colTypeToUid(colType: string): Uint8Array;
    colTypeFromUid(colTypeUid: Uint8Array): string;
}
export declare class CollectionCryptoManager extends CryptoManager {
    protected Collection: boolean;
    accountCryptoManager: AccountCryptoManager;
    constructor(accountCryptoManager: AccountCryptoManager, key: Uint8Array, version?: number);
}
export declare class CollectionItemCryptoManager extends CryptoManager {
    protected CollectionItem: boolean;
    constructor(key: Uint8Array, version?: number);
}
export declare class StorageCryptoManager extends CryptoManager {
    protected Storage: boolean;
    constructor(key: Uint8Array, version?: number);
}
export declare function getMainCryptoManager(mainEncryptionKey: Uint8Array, version: number): MainCryptoManager;
export declare class EncryptedCollection {
    private collectionKey;
    private collectionType;
    item: EncryptedCollectionItem;
    accessLevel: CollectionAccessLevel;
    stoken: string | null;
    static create<T>(parentCryptoManager: AccountCryptoManager, collectionTypeName: string, meta: ItemMetadata<T>, content: Uint8Array): Promise<EncryptedCollection>;
    static deserialize(json: CollectionJsonRead): EncryptedCollection;
    serialize(): CollectionJsonWrite;
    static cacheLoad(cached_: Uint8Array): EncryptedCollection;
    cacheSave(saveContent: boolean): Uint8Array;
    __markSaved(): void;
    verify(cryptoManager: CollectionCryptoManager): boolean;
    setMeta<T>(cryptoManager: CollectionCryptoManager, meta: ItemMetadata<T>): void;
    getMeta<T>(cryptoManager: CollectionCryptoManager): ItemMetadata<T>;
    setContent(cryptoManager: CollectionCryptoManager, content: Uint8Array): Promise<void>;
    getContent(cryptoManager: CollectionCryptoManager): Promise<Uint8Array>;
    delete(cryptoManager: CollectionCryptoManager, preserveContent: boolean): void;
    get isDeleted(): boolean;
    get uid(): string;
    get etag(): string;
    get lastEtag(): string | null;
    get version(): number;
    getCollectionType(parentCryptoManager: AccountCryptoManager): string;
    createInvitation(parentCryptoManager: AccountCryptoManager, identCryptoManager: BoxCryptoManager, username: string, pubkey: Uint8Array, accessLevel: CollectionAccessLevel): Promise<SignedInvitationWrite>;
    getCryptoManager(parentCryptoManager: AccountCryptoManager, version?: number): CollectionCryptoManager;
    private getCollectionKey;
}
export declare class EncryptedCollectionItem {
    uid: base64;
    version: number;
    private encryptionKey;
    private content;
    lastEtag: string | null;
    static create<T>(parentCryptoManager: CollectionCryptoManager, meta: ItemMetadata<T>, content: Uint8Array): Promise<EncryptedCollectionItem>;
    static deserialize(json: CollectionItemJsonRead): EncryptedCollectionItem;
    serialize(): CollectionItemJsonWrite;
    static cacheLoad(cached_: Uint8Array): EncryptedCollectionItem;
    cacheSave(saveContent: boolean): Uint8Array;
    __markSaved(): void;
    __getPendingChunks(): ChunkJson[];
    __getMissingChunks(): ChunkJson[];
    private isLocallyChanged;
    verify(cryptoManager: CollectionItemCryptoManager): boolean;
    setMeta<T>(cryptoManager: CollectionItemCryptoManager, meta: ItemMetadata<T>): void;
    getMeta<T>(cryptoManager: CollectionItemCryptoManager): ItemMetadata<T>;
    setContent(cryptoManager: CollectionItemCryptoManager, content: Uint8Array): Promise<void>;
    getContent(cryptoManager: CollectionItemCryptoManager): Promise<Uint8Array>;
    delete(cryptoManager: CollectionItemCryptoManager, preserveContent: boolean): void;
    get isDeleted(): boolean;
    get etag(): string;
    get isMissingContent(): boolean;
    getCryptoManager(parentCryptoManager: CollectionCryptoManager): CollectionItemCryptoManager;
    protected getAdditionalMacData(): Uint8Array;
}
