import { Scope } from "./scope";
import { Reference } from "./reference";
import { Definition } from "./definition";
import * as ESTree from "estree";
export declare enum VariableType {
    CatchClause = "CatchClause",
    Parameter = "Parameter",
    FunctionName = "FunctionName",
    ClassName = "ClassName",
    Variable = "Variable",
    ImportBinding = "ImportBinding",
    TDZ = "TDZ",
    ImplicitGlobalVariable = "ImplicitGlobalVariable",
    ExportDefault = "ExportDefault"
}
export declare class Variable {
    readonly name: string;
    readonly scope: Scope;
    readonly identifiers: ESTree.Identifier[];
    readonly references: Reference[];
    readonly defs: Definition[];
    tainted: boolean;
    stack: boolean;
    constructor(name: string, scope: Scope);
}
