"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class UnionFind {
    constructor(count) {
        this.roots = new Array(count);
        this.ranks = new Array(count);
        for (let i = 0; i < count; ++i) {
            this.roots[i] = i;
            this.ranks[i] = 0;
        }
    }
    get length() {
        return this.roots.length;
    }
    makeSet() {
        let n = this.roots.length;
        this.roots.push(n);
        this.ranks.push(0);
        return n;
    }
    find(x) {
        let x0 = x;
        const { roots } = this;
        while (roots[x] !== x) {
            x = roots[x];
        }
        while (roots[x0] !== x) {
            const y = roots[x0];
            roots[x0] = x;
            x0 = y;
        }
        return x;
    }
    union(x, y) {
        const xr = this.find(x);
        const yr = this.find(y);
        if (xr === yr) {
            return;
        }
        const { ranks, roots } = this;
        const xd = ranks[xr];
        const yd = ranks[yr];
        if (xd < yd) {
            roots[xr] = yr;
        }
        else if (yd < xd) {
            roots[yr] = xr;
        }
        else {
            roots[yr] = xr;
            ++ranks[xr];
        }
    }
}
exports.UnionFind = UnionFind;
//# sourceMappingURL=unionFind.js.map