import { Variable } from "../variable";
import { Reference, ImplicitGlobal } from "../reference";
import { ScopeManager } from "../scopeManager";
import { Definition } from "../definition";
import * as ESTree from "estree";
export declare type ScopeType = "TDZ" | "module" | "block" | "switch" | "function" | "catch" | "with" | "function" | "class" | "global" | "function-expression-name" | "for";
export declare class Scope<BlockType extends ESTree.Node = ESTree.Node> {
    readonly type: ScopeType;
    readonly upper: Scope | null;
    readonly block: BlockType;
    dynamic: boolean;
    variableScope: Scope;
    functionExpressionScope: boolean;
    directCallToEvalScope: boolean;
    thisFound: boolean;
    __left: Reference[] | null;
    isStrict: boolean;
    readonly set: Map<string, Variable>;
    readonly taints: Map<string, boolean>;
    readonly through: Reference[];
    readonly variables: Variable[];
    readonly references: Reference[];
    readonly childScopes: Scope[];
    readonly __declaredVariables: WeakMap<any, Variable[]>;
    constructor(scopeManager: ScopeManager, type: ScopeType, upper: Scope | null, block: BlockType, isMethodDefinition: boolean);
    __shouldStaticallyClose(scopeManager: ScopeManager): any;
    __shouldStaticallyCloseForGlobal(ref: Reference): boolean;
    __staticCloseRef(ref: Reference): void;
    __dynamicCloseRef(ref: Reference): void;
    __globalCloseRef(ref: Reference): void;
    __close(scopeManager: ScopeManager): Scope<ESTree.Node> | null;
    __isValidResolution(ref: Reference, variable: Variable): boolean;
    __resolve(ref: Reference): boolean;
    __delegateToUpperScope(ref: Reference): void;
    __addDeclaredVariablesOfNode(variable: Variable, node: ESTree.Node | undefined): void;
    protected __defineGeneric(name: string, set: Map<string, Variable>, variables: Variable[], node: any, def?: Definition): Variable;
    __define(node: ESTree.Node, def: Definition): Variable | null;
    __referencing(node: ESTree.Node, assign?: number, writeExpr?: ESTree.Expression, maybeImplicitGlobal?: ImplicitGlobal, partial?: boolean, init?: boolean, isExportingFromLocal?: boolean): Reference | undefined;
    __detectEval(): void;
    __detectThis(): void;
    __isClosed(): boolean;
    resolve(ident: ESTree.Identifier): Reference | null;
    isStatic(): boolean;
    isArgumentsMaterialized(): boolean;
    isThisMaterialized(): boolean;
    isUsedName(name: string): boolean;
}
