"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const scope_1 = require("./scope");
const importManager_1 = require("../importManager");
const exportManager_1 = require("../exportManager");
class ModuleScope extends scope_1.Scope {
    constructor(scopeManager, upperScope, block) {
        super(scopeManager, "module", upperScope, block, false);
        this.importManager = new importManager_1.ImportManager();
        this.exportManager = new exportManager_1.ExportManager();
        this.isExportingNamedDeclaration = false;
    }
    __define(node, def) {
        const ancestor = super.__define(node, def);
        if (ancestor !== null && this.isExportingNamedDeclaration) {
            this.exportManager.addLocalExportVariable({
                type: exportManager_1.ExportVariableType.Local,
                exportName: ancestor.name,
                localName: ancestor.name,
                node: ancestor.defs[0].node,
            });
        }
        return ancestor;
    }
}
exports.ModuleScope = ModuleScope;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibW9kdWxlU2NvcGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvc2NvcGUvbW9kdWxlU2NvcGUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxtQ0FBZ0M7QUFNaEMsb0RBQWlEO0FBQ2pELG9EQUUwQjtBQUUxQixpQkFBeUIsU0FBUSxhQUFLO0lBS3BDLFlBQ0UsWUFBMEIsRUFDMUIsVUFBaUIsRUFDakIsS0FBa0I7UUFFbEIsS0FBSyxDQUFDLFlBQVksRUFBRSxRQUFRLEVBQUUsVUFBVSxFQUFFLEtBQUssRUFBRSxLQUFLLENBQUMsQ0FBQztRQVQxQyxrQkFBYSxHQUFrQixJQUFJLDZCQUFhLEVBQUUsQ0FBQztRQUNuRCxrQkFBYSxHQUFrQixJQUFJLDZCQUFhLEVBQUUsQ0FBQztRQUM1RCxnQ0FBMkIsR0FBWSxLQUFLLENBQUM7SUFRcEQsQ0FBQztJQUVNLFFBQVEsQ0FDYixJQUFpQixFQUNqQixHQUFlO1FBRWYsTUFBTSxRQUFRLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLEVBQUUsR0FBRyxDQUFDLENBQUM7UUFDM0MsSUFBSSxRQUFRLEtBQUssSUFBSSxJQUFJLElBQUksQ0FBQywyQkFBMkIsRUFBRTtZQUN6RCxJQUFJLENBQUMsYUFBYSxDQUFDLHNCQUFzQixDQUFDO2dCQUN4QyxJQUFJLEVBQUUsa0NBQWtCLENBQUMsS0FBSztnQkFDOUIsVUFBVSxFQUFFLFFBQVEsQ0FBQyxJQUFJO2dCQUN6QixTQUFTLEVBQUUsUUFBUSxDQUFDLElBQUk7Z0JBQ3hCLElBQUksRUFBRSxRQUFRLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLElBQUk7YUFDNUIsQ0FBQyxDQUFDO1NBQ0o7UUFDRCxPQUFPLFFBQVEsQ0FBQztJQUNsQixDQUFDO0NBQ0Y7QUE1QkQsa0NBNEJDIn0=