"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const estraverse_1 = require("estraverse");
const scope_1 = require("./scope");
const variable_1 = require("../variable");
const definition_1 = require("../definition");
class GlobalScope extends scope_1.Scope {
    constructor(scopeManager, block) {
        super(scopeManager, "global", null, block, false);
        this.implicit = {
            set: new Map(),
            variables: [],
            left: [],
        };
    }
    __close(scopeManager) {
        const implicit = [];
        for (let i = 0, iz = this.__left.length; i < iz; ++i) {
            const ref = this.__left[i];
            if (ref.maybeImplicitGlobal &&
                !this.set.has(ref.identifier.name)) {
                implicit.push(ref.maybeImplicitGlobal);
            }
        }
        for (let i = 0, iz = implicit.length; i < iz; ++i) {
            const info = implicit[i];
            this.__defineImplicit(info.pattern, new definition_1.Definition(variable_1.VariableType.ImplicitGlobalVariable, info.pattern, info.node));
        }
        this.implicit.left = this.__left;
        return super.__close(scopeManager);
    }
    __defineImplicit(node, def) {
        if (node && node.type === estraverse_1.Syntax.Identifier) {
            this.__defineGeneric(node.name, this.implicit.set, this.implicit.variables, node, def);
        }
    }
}
exports.GlobalScope = GlobalScope;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ2xvYmFsU2NvcGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvc2NvcGUvZ2xvYmFsU2NvcGUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSwyQ0FBb0M7QUFDcEMsbUNBQWdDO0FBQ2hDLDBDQUFxRDtBQUVyRCw4Q0FBMkM7QUFVM0MsaUJBQXlCLFNBQVEsYUFBSztJQUdwQyxZQUFtQixZQUEwQixFQUFFLEtBQWtCO1FBQy9ELEtBQUssQ0FBQyxZQUFZLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxLQUFLLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFFbEQsSUFBSSxDQUFDLFFBQVEsR0FBRztZQUNkLEdBQUcsRUFBRSxJQUFJLEdBQUcsRUFBRTtZQUNkLFNBQVMsRUFBRSxFQUFFO1lBQ2IsSUFBSSxFQUFFLEVBQUU7U0FDVCxDQUFDO0lBQ0osQ0FBQztJQUVNLE9BQU8sQ0FBQyxZQUEwQjtRQUN2QyxNQUFNLFFBQVEsR0FBRyxFQUFFLENBQUM7UUFFcEIsS0FBSyxJQUFJLENBQUMsR0FBRyxDQUFDLEVBQUUsRUFBRSxHQUFHLElBQUksQ0FBQyxNQUFPLENBQUMsTUFBTSxFQUFFLENBQUMsR0FBRyxFQUFFLEVBQUUsRUFBRSxDQUFDLEVBQUU7WUFDckQsTUFBTSxHQUFHLEdBQUcsSUFBSSxDQUFDLE1BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQztZQUU1QixJQUNFLEdBQUcsQ0FBQyxtQkFBbUI7Z0JBQ3ZCLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxHQUFHLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsRUFDbEM7Z0JBQ0EsUUFBUSxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsbUJBQW1CLENBQUMsQ0FBQzthQUN4QztTQUNGO1FBR0QsS0FBSyxJQUFJLENBQUMsR0FBRyxDQUFDLEVBQUUsRUFBRSxHQUFHLFFBQVEsQ0FBQyxNQUFNLEVBQUUsQ0FBQyxHQUFHLEVBQUUsRUFBRSxFQUFFLENBQUMsRUFBRTtZQUNqRCxNQUFNLElBQUksR0FBRyxRQUFRLENBQUMsQ0FBQyxDQUFDLENBQUM7WUFFekIsSUFBSSxDQUFDLGdCQUFnQixDQUNuQixJQUFJLENBQUMsT0FBTyxFQUNaLElBQUksdUJBQVUsQ0FDWix1QkFBWSxDQUFDLHNCQUFzQixFQUNuQyxJQUFJLENBQUMsT0FBTyxFQUNaLElBQUksQ0FBQyxJQUFJLENBQ1YsQ0FDRixDQUFDO1NBQ0g7UUFFRCxJQUFJLENBQUMsUUFBUSxDQUFDLElBQUksR0FBRyxJQUFJLENBQUMsTUFBTyxDQUFDO1FBRWxDLE9BQU8sS0FBSyxDQUFDLE9BQU8sQ0FBQyxZQUFZLENBQUMsQ0FBQztJQUNyQyxDQUFDO0lBRU0sZ0JBQWdCLENBQUMsSUFBaUIsRUFBRSxHQUFlO1FBQ3hELElBQUksSUFBSSxJQUFJLElBQUksQ0FBQyxJQUFJLEtBQUssbUJBQU0sQ0FBQyxVQUFVLEVBQUU7WUFDM0MsSUFBSSxDQUFDLGVBQWUsQ0FDbEIsSUFBSSxDQUFDLElBQUksRUFDVCxJQUFJLENBQUMsUUFBUSxDQUFDLEdBQUcsRUFDakIsSUFBSSxDQUFDLFFBQVEsQ0FBQyxTQUFTLEVBQ3ZCLElBQUksRUFDSixHQUFHLENBQ0osQ0FBQztTQUNIO0lBQ0gsQ0FBQztDQUNGO0FBekRELGtDQXlEQyJ9