"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const estraverse_1 = require("estraverse");
const scope_1 = require("./scope");
const assert = require("assert");
class FunctionScope extends scope_1.Scope {
    constructor(scopeManager, upperScope, block, isMethodDefinition) {
        super(scopeManager, "function", upperScope, block, isMethodDefinition);
        if (this.block.type !== estraverse_1.Syntax.ArrowFunctionExpression) {
            this.__defineArguments();
        }
    }
    isArgumentsMaterialized() {
        if (this.block.type === estraverse_1.Syntax.ArrowFunctionExpression) {
            return false;
        }
        if (!this.isStatic()) {
            return true;
        }
        const variable = this.set.get("arguments");
        assert(typeof variable !== "undefined", "Always have arguments variable.");
        return (variable.tainted || variable.references.length !== 0);
    }
    isThisMaterialized() {
        if (!this.isStatic()) {
            return true;
        }
        return this.thisFound;
    }
    __defineArguments() {
        this.__defineGeneric("arguments", this.set, this.variables, null);
        this.taints.set("arguments", true);
    }
    __isValidResolution(ref, variable) {
        if (this.block.type === "Program") {
            return true;
        }
        const bodyStart = this.block.body.range[0];
        return !(variable.scope === this &&
            ref.identifier.range[0] < bodyStart &&
            variable.defs.every(d => d.name.range[0] >= bodyStart));
    }
}
exports.FunctionScope = FunctionScope;
//# sourceMappingURL=data:application/json;base64,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