import * as esrecurse from "esrecurse";
import { ImplicitGlobal } from "./reference";
import { VariableType } from "./variable";
import { PatternVisitorCallback, AssignmentType } from "./patternVisitor";
import { ScopeManager } from "./scopeManager";
import { Scope } from "./scope";
import * as ESTree from "estree";
export declare class Referencer extends esrecurse.Visitor {
    readonly options: esrecurse.VisitorOption;
    readonly scopeManager: ScopeManager;
    parent: Referencer | null;
    isInnerMethodDefinition: boolean;
    exportingSource: string | null;
    isExportingFromLocal: boolean;
    constructor(options: esrecurse.VisitorOption, scopeManager: ScopeManager);
    readonly currentScope: Scope<ESTree.Node> | null;
    close(node: ESTree.Node): void;
    pushInnerMethodDefinition(isInnerMethodDefinition: boolean): boolean;
    popInnerMethodDefinition(isInnerMethodDefinition: boolean): void;
    materializeTDZScope(node: ESTree.Node, iterationNode: ESTree.ForOfStatement | ESTree.ForInStatement): void;
    materializeIterationScope(node: ESTree.ForInStatement | ESTree.ForOfStatement): void;
    referencingDefaultValue(pattern: ESTree.Pattern, assignments: AssignmentType[], maybeImplicitGlobal?: ImplicitGlobal, init?: boolean): void;
    visitPattern(node: ESTree.Pattern, options: {
        processRightHandNodes: boolean;
    } | undefined, callback: PatternVisitorCallback): void;
    visitFunction(node: ESTree.Function): void;
    visitClass(node: ESTree.Class): void;
    visitProperty(node: any): void;
    visitForIn(node: ESTree.ForInStatement | ESTree.ForOfStatement): void;
    visitVariableDeclaration(variableTargetScope: Scope, type: VariableType, node: ESTree.VariableDeclaration, index: number, fromTDZ?: boolean): void;
    AssignmentExpression(node: ESTree.AssignmentExpression): void;
    CatchClause(node: ESTree.CatchClause): void;
    Program(node: ESTree.Program): void;
    Identifier(node: ESTree.Identifier): void;
    UpdateExpression(node: ESTree.UpdateExpression): void;
    MemberExpression(node: ESTree.MemberExpression): void;
    Property(node: ESTree.Property): void;
    MethodDefinition(node: ESTree.MethodDefinition): void;
    BreakStatement(): void;
    ContinueStatement(): void;
    LabeledStatement(node: ESTree.LabeledStatement): void;
    ForStatement(node: ESTree.ForStatement): void;
    ClassExpression(node: ESTree.ClassExpression): void;
    ClassDeclaration(node: ESTree.ClassDeclaration): void;
    CallExpression(node: ESTree.CallExpression): void;
    BlockStatement(node: ESTree.BlockStatement): void;
    ThisExpression(): void;
    WithStatement(node: ESTree.WithStatement): void;
    VariableDeclaration(node: ESTree.VariableDeclaration): void;
    SwitchStatement(node: ESTree.SwitchStatement): void;
    FunctionDeclaration(node: ESTree.FunctionDeclaration): void;
    FunctionExpression(node: ESTree.FunctionExpression): void;
    ForOfStatement(node: ESTree.ForOfStatement): void;
    ForInStatement(node: ESTree.ForInStatement): void;
    ArrowFunctionExpression(node: ESTree.ArrowFunctionExpression): void;
    ImportDeclaration(node: ESTree.ImportDeclaration): void;
    visitExportDeclaration(node: ESTree.ExportNamedDeclaration): void;
    ExportNamedDeclaration(node: ESTree.ExportNamedDeclaration): void;
    ExportDefaultDeclaration(node: ESTree.ExportDefaultDeclaration): void;
    ExportAllDeclaration(node: ESTree.ExportAllDeclaration): void;
    ExportSpecifier(node: ESTree.ExportSpecifier): void;
    MetaProperty(): void;
}
