"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const __READ = 0x1;
const __WRITE = 0x2;
const __RW = __READ | __WRITE;
const __EXPORT = 0x4;
class Reference {
    constructor(identifier, from, flag, writeExpr, maybeImplicitGlobal = null, partial, init) {
        this.identifier = identifier;
        this.from = from;
        this.flag = flag;
        this.maybeImplicitGlobal = maybeImplicitGlobal;
        this.tainted = false;
        this.tainted = false;
        this.resolved = null;
        this.flag = flag;
        if (this.isWrite) {
            this.writeExpr = writeExpr;
            this.partial = partial;
            this.init = init;
        }
    }
    get isStatic() {
        return (!this.tainted &&
            this.resolved &&
            this.resolved.scope.isStatic());
    }
    get isWrite() {
        return !!(this.flag & Reference.WRITE);
    }
    get isRead() {
        return !!(this.flag & Reference.READ);
    }
    get isReadOnly() {
        return this.flag === Reference.READ;
    }
    get isWriteOnly() {
        return this.flag === Reference.WRITE;
    }
    get isReadWrite() {
        return this.flag === Reference.RW;
    }
    get isExport() {
        return this.flag === Reference.EXPORT;
    }
}
Reference.READ = __READ;
Reference.WRITE = __WRITE;
Reference.RW = __RW;
Reference.EXPORT = __EXPORT;
exports.Reference = Reference;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmVmZXJlbmNlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL3JlZmVyZW5jZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUlBLE1BQU0sTUFBTSxHQUFHLEdBQUcsQ0FBQztBQUNuQixNQUFNLE9BQU8sR0FBRyxHQUFHLENBQUM7QUFDcEIsTUFBTSxJQUFJLEdBQUcsTUFBTSxHQUFHLE9BQU8sQ0FBQztBQUM5QixNQUFNLFFBQVEsR0FBRyxHQUFHLENBQUM7QUFVckI7SUFhRSxZQUNrQixVQUE2QixFQUM3QixJQUFXLEVBQ1gsSUFBWSxFQUM1QixTQUE2QixFQUNiLHNCQUE2QyxJQUFJLEVBQ2pFLE9BQWlCLEVBQ2pCLElBQWM7UUFORSxlQUFVLEdBQVYsVUFBVSxDQUFtQjtRQUM3QixTQUFJLEdBQUosSUFBSSxDQUFPO1FBQ1gsU0FBSSxHQUFKLElBQUksQ0FBUTtRQUVaLHdCQUFtQixHQUFuQixtQkFBbUIsQ0FBOEI7UUFaNUQsWUFBTyxHQUFZLEtBQUssQ0FBQztRQW9COUIsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUM7UUFLckIsSUFBSSxDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUM7UUFFckIsSUFBSSxDQUFDLElBQUksR0FBRyxJQUFJLENBQUM7UUFDakIsSUFBSSxJQUFJLENBQUMsT0FBTyxFQUFFO1lBQ2hCLElBQUksQ0FBQyxTQUFTLEdBQUcsU0FBUyxDQUFDO1lBQzNCLElBQUksQ0FBQyxPQUFPLEdBQUcsT0FBTyxDQUFDO1lBQ3ZCLElBQUksQ0FBQyxJQUFJLEdBQUcsSUFBSSxDQUFDO1NBQ2xCO0lBQ0gsQ0FBQztJQUtELElBQUksUUFBUTtRQUNWLE9BQU8sQ0FDTCxDQUFDLElBQUksQ0FBQyxPQUFPO1lBQ2IsSUFBSSxDQUFDLFFBQVE7WUFDYixJQUFJLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQyxRQUFRLEVBQUUsQ0FDL0IsQ0FBQztJQUNKLENBQUM7SUFLRCxJQUFJLE9BQU87UUFDVCxPQUFPLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxJQUFJLEdBQUcsU0FBUyxDQUFDLEtBQUssQ0FBQyxDQUFDO0lBQ3pDLENBQUM7SUFLRCxJQUFJLE1BQU07UUFDUixPQUFPLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxJQUFJLEdBQUcsU0FBUyxDQUFDLElBQUksQ0FBQyxDQUFDO0lBQ3hDLENBQUM7SUFLRCxJQUFJLFVBQVU7UUFDWixPQUFPLElBQUksQ0FBQyxJQUFJLEtBQUssU0FBUyxDQUFDLElBQUksQ0FBQztJQUN0QyxDQUFDO0lBS0QsSUFBSSxXQUFXO1FBQ2IsT0FBTyxJQUFJLENBQUMsSUFBSSxLQUFLLFNBQVMsQ0FBQyxLQUFLLENBQUM7SUFDdkMsQ0FBQztJQUtELElBQUksV0FBVztRQUNiLE9BQU8sSUFBSSxDQUFDLElBQUksS0FBSyxTQUFTLENBQUMsRUFBRSxDQUFDO0lBQ3BDLENBQUM7SUFFRCxJQUFJLFFBQVE7UUFDVixPQUFPLElBQUksQ0FBQyxJQUFJLEtBQUssU0FBUyxDQUFDLE1BQU0sQ0FBQztJQUN4QyxDQUFDOztBQXhGYSxjQUFJLEdBQUcsTUFBTSxDQUFDO0FBQ2QsZUFBSyxHQUFHLE9BQU8sQ0FBQztBQUNoQixZQUFFLEdBQUcsSUFBSSxDQUFDO0FBQ1YsZ0JBQU0sR0FBRyxRQUFRLENBQUM7QUFKbEMsOEJBMEZDIn0=