import { Scope } from "./scope";
import { Variable } from "./variable";
import * as ESTree from "estree";
export interface ImplicitGlobal {
    pattern: ESTree.Identifier;
    node: ESTree.Node;
}
export declare class Reference {
    readonly identifier: ESTree.Identifier;
    readonly from: Scope;
    readonly flag: number;
    readonly maybeImplicitGlobal: ImplicitGlobal | null;
    static READ: number;
    static WRITE: number;
    static RW: number;
    static EXPORT: number;
    tainted: boolean;
    resolved: Variable | null;
    readonly writeExpr?: ESTree.Expression;
    readonly partial?: boolean;
    readonly init?: boolean;
    constructor(identifier: ESTree.Identifier, from: Scope, flag: number, writeExpr?: ESTree.Expression, maybeImplicitGlobal?: ImplicitGlobal | null, partial?: boolean, init?: boolean);
    readonly isStatic: boolean | null;
    readonly isWrite: boolean;
    readonly isRead: boolean;
    readonly isReadOnly: boolean;
    readonly isWriteOnly: boolean;
    readonly isReadWrite: boolean;
    readonly isExport: boolean;
}
