import * as esrecurse from "esrecurse";
import * as ESTree from "estree";
export declare type AssignmentType = ESTree.AssignmentPattern | ESTree.AssignmentExpression;
export interface ICallbackOption {
    topLevel: boolean;
    rest: boolean;
    assignments: AssignmentType[];
}
export declare type PatternVisitorCallback = (id: ESTree.Identifier, option: ICallbackOption) => void;
export declare class PatternVisitor extends esrecurse.Visitor {
    static isPattern(node: ESTree.Node): boolean;
    rootPattern: any;
    callback: PatternVisitorCallback;
    assignments: AssignmentType[];
    rightHandNodes: any[];
    restElements: any[];
    constructor(options: esrecurse.VisitorOption, rootPattern: ESTree.Node, callback: PatternVisitorCallback);
    Identifier(pattern: ESTree.Identifier): void;
    Property(property: ESTree.Property): void;
    ArrayPattern(pattern: ESTree.ArrayPattern): void;
    AssignmentPattern(pattern: ESTree.AssignmentPattern): void;
    RestElement(pattern: ESTree.RestElement): void;
    MemberExpression(node: ESTree.MemberExpression): void;
    SpreadElement(node: ESTree.SpreadElement): void;
    ArrayExpression(node: ESTree.ArrayExpression): void;
    AssignmentExpression(node: ESTree.AssignmentExpression): void;
    CallExpression(node: ESTree.CallExpression): void;
}
