"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var ImportType;
(function (ImportType) {
    ImportType["Default"] = "Default";
    ImportType["Identifier"] = "Identifier";
    ImportType["Namespace"] = "Namespace";
})(ImportType = exports.ImportType || (exports.ImportType = {}));
class ImportIdentifierInfo {
    constructor(localName, sourceName, moduleName, type) {
        this.localName = localName;
        this.sourceName = sourceName;
        this.moduleName = moduleName;
        this.type = type;
    }
}
exports.ImportIdentifierInfo = ImportIdentifierInfo;
class ImportManager {
    constructor() {
        this.idMap = new Map();
    }
    addImportId(importId) {
        this.idMap.set(importId.localName, importId);
    }
    get ids() {
        return [...this.idMap.values()];
    }
}
exports.ImportManager = ImportManager;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW1wb3J0TWFuYWdlci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9pbXBvcnRNYW5hZ2VyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsSUFBWSxVQUlYO0FBSkQsV0FBWSxVQUFVO0lBQ3BCLGlDQUFtQixDQUFBO0lBQ25CLHVDQUF5QixDQUFBO0lBQ3pCLHFDQUF1QixDQUFBO0FBQ3pCLENBQUMsRUFKVyxVQUFVLEdBQVYsa0JBQVUsS0FBVixrQkFBVSxRQUlyQjtBQUVEO0lBQ0UsWUFDa0IsU0FBaUIsRUFDakIsVUFBa0IsRUFDbEIsVUFBa0IsRUFDbEIsSUFBZ0I7UUFIaEIsY0FBUyxHQUFULFNBQVMsQ0FBUTtRQUNqQixlQUFVLEdBQVYsVUFBVSxDQUFRO1FBQ2xCLGVBQVUsR0FBVixVQUFVLENBQVE7UUFDbEIsU0FBSSxHQUFKLElBQUksQ0FBWTtJQUMvQixDQUFDO0NBQ0w7QUFQRCxvREFPQztBQUVEO0lBQUE7UUFDa0IsVUFBSyxHQUdqQixJQUFJLEdBQUcsRUFBRSxDQUFDO0lBU2hCLENBQUM7SUFQUSxXQUFXLENBQUMsUUFBOEI7UUFDL0MsSUFBSSxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsUUFBUSxDQUFDLFNBQVMsRUFBRSxRQUFRLENBQUMsQ0FBQztJQUMvQyxDQUFDO0lBRUQsSUFBSSxHQUFHO1FBQ0wsT0FBTyxDQUFDLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxNQUFNLEVBQUUsQ0FBQyxDQUFDO0lBQ2xDLENBQUM7Q0FDRjtBQWJELHNDQWFDIn0=