export declare enum ImportType {
    Default = "Default",
    Identifier = "Identifier",
    Namespace = "Namespace"
}
export declare class ImportIdentifierInfo {
    readonly localName: string;
    readonly sourceName: string;
    readonly moduleName: string;
    readonly type: ImportType;
    constructor(localName: string, sourceName: string, moduleName: string, type: ImportType);
}
export declare class ImportManager {
    readonly idMap: Map<string, ImportIdentifierInfo>;
    addImportId(importId: ImportIdentifierInfo): void;
    readonly ids: ImportIdentifierInfo[];
}
