"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var ExternalType;
(function (ExternalType) {
    ExternalType["Identifier"] = "identifier";
    ExternalType["All"] = "all";
})(ExternalType = exports.ExternalType || (exports.ExternalType = {}));
var ExportVariableType;
(function (ExportVariableType) {
    ExportVariableType["Local"] = "local";
    ExportVariableType["External"] = "external";
})(ExportVariableType = exports.ExportVariableType || (exports.ExportVariableType = {}));
class ExportManager {
    constructor() {
        this.exportsMap = new Map();
        this.localVariables = [];
        this.externalVariables = [];
        this.exportDefaultDeclaration = null;
    }
    addLocalExportVariable(exportVar) {
        this.exportsMap.set(exportVar.exportName, exportVar);
        this.localVariables.push(exportVar);
        if (exportVar.exportName === "default") {
            this.exportDefaultDeclaration = exportVar.node;
        }
    }
    addExternalVariable(external) {
        this.externalVariables.push(external);
        if (external.moduleType === ExternalType.Identifier) {
            this.exportsMap.set(external.names.exportName, external);
        }
    }
}
exports.ExportManager = ExportManager;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZXhwb3J0TWFuYWdlci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9leHBvcnRNYW5hZ2VyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBR0EsSUFBWSxZQUdYO0FBSEQsV0FBWSxZQUFZO0lBQ3RCLHlDQUF5QixDQUFBO0lBQ3pCLDJCQUFXLENBQUE7QUFDYixDQUFDLEVBSFcsWUFBWSxHQUFaLG9CQUFZLEtBQVosb0JBQVksUUFHdkI7QUFFRCxJQUFZLGtCQUdYO0FBSEQsV0FBWSxrQkFBa0I7SUFDNUIscUNBQWUsQ0FBQTtJQUNmLDJDQUFxQixDQUFBO0FBQ3ZCLENBQUMsRUFIVyxrQkFBa0IsR0FBbEIsMEJBQWtCLEtBQWxCLDBCQUFrQixRQUc3QjtBQXFCRDtJQUFBO1FBQ2tCLGVBQVUsR0FBZ0MsSUFBSSxHQUFHLEVBQUUsQ0FBQztRQUNwRCxtQkFBYyxHQUEwQixFQUFFLENBQUM7UUFDM0Msc0JBQWlCLEdBQXVCLEVBQUUsQ0FBQztRQUNwRCw2QkFBd0IsR0FBdUIsSUFBSSxDQUFDO0lBaUI3RCxDQUFDO0lBZlEsc0JBQXNCLENBQUMsU0FBOEI7UUFDMUQsSUFBSSxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsU0FBUyxDQUFDLFVBQVUsRUFBRSxTQUFTLENBQUMsQ0FBQztRQUNyRCxJQUFJLENBQUMsY0FBYyxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsQ0FBQztRQUNwQyxJQUFJLFNBQVMsQ0FBQyxVQUFVLEtBQUssU0FBUyxFQUFFO1lBQ3RDLElBQUksQ0FBQyx3QkFBd0IsR0FBRyxTQUFTLENBQUMsSUFBdUMsQ0FBQztTQUNuRjtJQUNILENBQUM7SUFFTSxtQkFBbUIsQ0FBQyxRQUEwQjtRQUNuRCxJQUFJLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxDQUFDO1FBQ3RDLElBQUksUUFBUSxDQUFDLFVBQVUsS0FBSyxZQUFZLENBQUMsVUFBVSxFQUFFO1lBQ2pELElBQUksQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLFFBQVEsQ0FBQyxLQUFNLENBQUMsVUFBVSxFQUFFLFFBQVEsQ0FBQyxDQUFDO1NBQzdEO0lBQ0gsQ0FBQztDQUVGO0FBckJELHNDQXFCQyJ9