import * as ESTree from "estree";
export declare enum ExternalType {
    Identifier = "identifier",
    All = "all"
}
export declare enum ExportVariableType {
    Local = "local",
    External = "external"
}
export interface LocalExportVariable {
    type: ExportVariableType.Local;
    exportName: string;
    localName: string | null;
    node: ESTree.Node;
}
export interface ExternalVariable {
    type: ExportVariableType.External;
    moduleName: string;
    moduleType: ExternalType;
    names?: {
        exportName: string;
        sourceName: string;
    };
}
export declare type ExportVariable = LocalExportVariable | ExternalVariable;
export declare class ExportManager {
    readonly exportsMap: Map<string, ExportVariable>;
    readonly localVariables: LocalExportVariable[];
    readonly externalVariables: ExternalVariable[];
    exportDefaultDeclaration: ESTree.Node | null;
    addLocalExportVariable(exportVar: LocalExportVariable): void;
    addExternalVariable(external: ExternalVariable): void;
}
