"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const _1 = require(".");
class ExportDefaultVirtualScope {
    constructor(contentType, declaration, isChildrenDependent = true) {
        this.contentType = contentType;
        this.declaration = declaration;
        this.isChildrenDependent = isChildrenDependent;
        this.children = [];
    }
    get type() {
        return _1.VirtualScopeType.Default;
    }
    findAllReferencesToVirtualScope(visitedSet, scopeManager, virtualScopeMap) {
        const moduleScope = this.getModuleScope(scopeManager);
        if (this.contentType === _1.VScopeContentType.Reference) {
            const id = this.declaration;
            const idName = id.name;
            const variable = moduleScope.set.get(idName);
            const vs = virtualScopeMap.get(variable);
            this.children.push(vs);
        }
        else {
            const scopes = scopeManager.__nodeToScope.get(this.declaration);
            this.traverseScopes(scopes, moduleScope, visitedSet, virtualScopeMap);
        }
    }
    getModuleScope(scopeManager) {
        return scopeManager.scopes[1];
    }
    traverseScopes(scopes, moduleScope, visitedSet, virtualScopeMap) {
        scopes.forEach(scope => {
            visitedSet.add(scope);
            const traverse = (scope) => {
                scope.references.forEach(ref => {
                    if (ref.resolved &&
                        ref.resolved.scope.type === "module") {
                        const idName = ref.identifier.name;
                        this.addToVs(idName, moduleScope, virtualScopeMap);
                    }
                });
                scope.childScopes.forEach(traverse);
            };
            traverse(scope);
        });
    }
    addToVs(idName, moduleScope, virtualScopeMap) {
        const refVar = moduleScope.set.get(idName);
        const virtualScope = virtualScopeMap.get(refVar);
        this.children.push(virtualScope);
    }
}
exports.ExportDefaultVirtualScope = ExportDefaultVirtualScope;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZXhwb3J0RGVmYXVsdFZpcnR1YWxTY29wZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9hbmFseXNlci92aXJ0dWFsU2NvcGUvZXhwb3J0RGVmYXVsdFZpcnR1YWxTY29wZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLHdCQUFzRTtBQUl0RTtJQUlFLFlBQ2tCLFdBQThCLEVBQzlCLFdBQXdCLEVBQ2pDLHNCQUErQixJQUFJO1FBRjFCLGdCQUFXLEdBQVgsV0FBVyxDQUFtQjtRQUM5QixnQkFBVyxHQUFYLFdBQVcsQ0FBYTtRQUNqQyx3QkFBbUIsR0FBbkIsbUJBQW1CLENBQWdCO1FBTDVCLGFBQVEsR0FBbUIsRUFBRSxDQUFDO0lBTTNDLENBQUM7SUFFSixJQUFXLElBQUk7UUFDYixPQUFPLG1CQUFnQixDQUFDLE9BQU8sQ0FBQztJQUNsQyxDQUFDO0lBRU0sK0JBQStCLENBQ3BDLFVBQTBCLEVBQzFCLFlBQTBCLEVBQzFCLGVBQWdEO1FBRWhELE1BQU0sV0FBVyxHQUFHLElBQUksQ0FBQyxjQUFjLENBQUMsWUFBWSxDQUFDLENBQUM7UUFDdEQsSUFBSSxJQUFJLENBQUMsV0FBVyxLQUFLLG9CQUFpQixDQUFDLFNBQVMsRUFBRTtZQUNwRCxNQUFNLEVBQUUsR0FBRyxJQUFJLENBQUMsV0FBZ0MsQ0FBQztZQUNqRCxNQUFNLE1BQU0sR0FBRyxFQUFFLENBQUMsSUFBSSxDQUFDO1lBQ3ZCLE1BQU0sUUFBUSxHQUFHLFdBQVcsQ0FBQyxHQUFHLENBQUMsR0FBRyxDQUFDLE1BQU0sQ0FBRSxDQUFDO1lBQzlDLE1BQU0sRUFBRSxHQUFHLGVBQWUsQ0FBQyxHQUFHLENBQUMsUUFBUSxDQUFFLENBQUM7WUFDMUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsRUFBRSxDQUFDLENBQUM7U0FDeEI7YUFBTTtZQUNMLE1BQU0sTUFBTSxHQUFHLFlBQWEsQ0FBQyxhQUFhLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUUsQ0FBQztZQUNsRSxJQUFJLENBQUMsY0FBYyxDQUNqQixNQUFNLEVBQ04sV0FBVyxFQUNYLFVBQVUsRUFDVixlQUFlLENBQ2hCLENBQUM7U0FDSDtJQUNILENBQUM7SUFFTyxjQUFjLENBQUMsWUFBMEI7UUFDL0MsT0FBTyxZQUFhLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBZ0IsQ0FBQztJQUNoRCxDQUFDO0lBRU8sY0FBYyxDQUNwQixNQUFlLEVBQ2YsV0FBd0IsRUFDeEIsVUFBMEIsRUFDMUIsZUFBZ0Q7UUFFaEQsTUFBTSxDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUMsRUFBRTtZQUNyQixVQUFVLENBQUMsR0FBRyxDQUFDLEtBQUssQ0FBQyxDQUFDO1lBTXRCLE1BQU0sUUFBUSxHQUFHLENBQUMsS0FBWSxFQUFFLEVBQUU7Z0JBRWhDLEtBQUssQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxFQUFFO29CQUM3QixJQUNFLEdBQUcsQ0FBQyxRQUFRO3dCQUNaLEdBQUcsQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLElBQUksS0FBSyxRQUFRLEVBQ3BDO3dCQUNBLE1BQU0sTUFBTSxHQUFHLEdBQUcsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDO3dCQUNuQyxJQUFJLENBQUMsT0FBTyxDQUFDLE1BQU0sRUFBRSxXQUFXLEVBQUUsZUFBZSxDQUFDLENBQUM7cUJBQ3BEO2dCQUNILENBQUMsQ0FBQyxDQUFDO2dCQUNILEtBQUssQ0FBQyxXQUFXLENBQUMsT0FBTyxDQUFDLFFBQVEsQ0FBQyxDQUFDO1lBQ3RDLENBQUMsQ0FBQztZQUVGLFFBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUNsQixDQUFDLENBQUMsQ0FBQztJQUNMLENBQUM7SUFFTyxPQUFPLENBQ2IsTUFBYyxFQUNkLFdBQXdCLEVBQ3hCLGVBQWdEO1FBRWhELE1BQU0sTUFBTSxHQUFHLFdBQVcsQ0FBQyxHQUFHLENBQUMsR0FBRyxDQUFDLE1BQU0sQ0FBRSxDQUFDO1FBQzVDLE1BQU0sWUFBWSxHQUFHLGVBQWUsQ0FBQyxHQUFHLENBQUMsTUFBTSxDQUFFLENBQUM7UUFDbEQsSUFBSSxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLENBQUM7SUFDbkMsQ0FBQztDQUVGO0FBbEZELDhEQWtGQyJ9