import { ScopeManager } from "../scopeManager";
import * as ESTree from "estree";
import { ModuleScope } from "../scope";
import { RefsToModuleExtractor } from "./childScopesTraverser";
import { Variable } from "../variable";
import { VirtualScope } from "./virtualScope";
export interface Dictionary<T> {
    [index: string]: T;
}
export interface ExportInfo {
    sourceName: string | true;
    moduleName: string;
}
export declare class ModuleAnalyser {
    readonly name: string;
    readonly module: any;
    scopeManager: ScopeManager | null;
    readonly extractorMap: Map<string, RefsToModuleExtractor>;
    readonly virtualScopeMap: WeakMap<Variable, VirtualScope>;
    readonly virtualScopes: VirtualScope[];
    readonly initVirtualScopes: VirtualScope[];
    private comments;
    constructor(name: string, module: any, scopeManager?: ScopeManager | null);
    defaultOptions(): {
        optimistic: boolean;
        directive: boolean;
        nodejsScope: boolean;
        impliedStrict: boolean;
        sourceType: string;
        ecmaVersion: number;
        childVisitorKeys: null;
        fallback: string;
        comments: never[];
    };
    analyze(tree: ESTree.Node, providedOptions?: any): void;
    private processComments;
    private handleExportDefaultDeclaration;
    generateExportInfo(usedExports: string[]): Dictionary<boolean | string[] | Set<string>>;
    private traverseIndependentScopes;
    private handleNotExportReferences;
    private updateDeeply;
    readonly moduleScope: ModuleScope;
}
