"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const estraverse = require("estraverse");
class PureDeclaratorTraverser {
    constructor(validatorDeclarator, moduleScope) {
        this.validatorDeclarator = validatorDeclarator;
        this.moduleScope = moduleScope;
        this.refsToModule = [];
        this.relevantScopes = [];
        this.ids = [];
        moduleScope.childScopes.forEach(scope => {
            const block = scope.block;
            if (this.nodeContains(validatorDeclarator, block)) {
                this.relevantScopes.push(scope);
            }
        });
        estraverse.traverse(validatorDeclarator, {
            enter: (node) => {
                if (node.type === "Identifier") {
                    this.ids.push(node);
                    const idName = node.name;
                    this.refsToModule.push(idName);
                }
            },
        });
    }
    nodeContains(node1, node2) {
        return node2.start >= node1.start && node2.end <= node1.end;
    }
}
exports.PureDeclaratorTraverser = PureDeclaratorTraverser;
class ChildScopesTraverser {
    constructor(scope) {
        this.scope = scope;
        this.refsToModule = [];
        this.traverse = (scope) => {
            scope.references.forEach(ref => {
                if (ref.resolved &&
                    ref.resolved.scope.type === "module") {
                    this.refsToModule.push(ref.identifier.name);
                }
            });
            scope.childScopes.forEach(this.traverse);
        };
        this.traverse(scope);
    }
}
exports.ChildScopesTraverser = ChildScopesTraverser;
//# sourceMappingURL=data:application/json;base64,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