export interface Options {
    maxWait?: number;
    leading?: boolean;
    trailing?: boolean;
}
export interface ControlFunctions {
    cancel: () => void;
    flush: () => void;
    pending: () => boolean;
}
export interface DebouncedState<T extends unknown[]> extends ControlFunctions {
    callback: (...args: T) => unknown;
}
export default function useDebouncedCallback<T extends unknown[]>(func: (...args: T) => unknown, wait: number, options?: Options): DebouncedState<T>;
