"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
async function request(url, options = {}) {
    return new Promise((resolve, reject) => {
        var _a, _b;
        const xhr = new XMLHttpRequest();
        xhr.open((_b = (_a = options.method) === null || _a === void 0 ? void 0 : _a.toUpperCase()) !== null && _b !== void 0 ? _b : "GET", url, true);
        xhr.responseType = "arraybuffer";
        if (options.headers) {
            for (const x of Object.keys(options.headers)) {
                xhr.setRequestHeader(x, options.headers[x].toString());
            }
        }
        xhr.onload = () => {
            const body = xhr.response;
            resolve({
                type: "default",
                status: xhr.status,
                statusText: xhr.statusText,
                ok: xhr.status >= 200 && xhr.status < 300,
                body,
            });
        };
        xhr.onerror = () => {
            setTimeout(() => reject(new TypeError("Network request failed")), 0);
        };
        xhr.ontimeout = () => {
            setTimeout(() => reject(new TypeError("Network request failed")), 0);
        };
        xhr.onabort = () => {
            setTimeout(() => reject(new DOMException("Aborted", "AbortError")), 0);
        };
        xhr.send(options.body);
    });
}
async function requestNode(url, options = {}) {
    const fetch = await require("node-fetch");
    const response = await fetch(url, options);
    const ret = {
        type: "default",
        status: response.status,
        statusText: response.statusText,
        ok: response.ok,
        body: new Uint8Array(await response.arrayBuffer()),
    };
    return ret;
}
exports.default = ((typeof global === "undefined") || global.XMLHttpRequest) ? request : requestNode;
//# sourceMappingURL=Request.js.map