"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const Helpers_1 = require("./Helpers");
const Crypto_1 = require("./Crypto");
it("Buffer to number", () => {
    const numbers = [
        0,
        123,
        12314,
        123123,
        4324234,
        32434234,
        2147483648,
        3352352352,
    ];
    for (const num of numbers) {
        const buf = Helpers_1.numToUint8Array(num);
        expect(num).toEqual(Helpers_1.numFromUint8Array(buf));
    }
});
it("Padding is larger than content", async () => {
    // Because of how we use padding (unpadding) we need to make sure padding is always larger than the content
    // Otherwise we risk the unpadder to fail thinking it should unpad when it shouldn't.
    for (let i = 1; i < (1 << 14); i++) {
        if (Helpers_1.getPadding(i) <= i) {
            // Always fail here.
            expect(i).toEqual(-1);
        }
    }
    expect(Helpers_1.getPadding(2343242)).toEqual(2359296);
});
it("Padding fixed size", async () => {
    await Crypto_1.ready;
    const blocksize = 32;
    for (let i = 1; i < blocksize * 2; i++) {
        const buf = new Uint8Array(i);
        buf.fill(60);
        const padded = Helpers_1.bufferPadFixed(buf, blocksize);
        const unpadded = Helpers_1.bufferUnpadFixed(padded, blocksize);
        expect(unpadded).toEqual(buf);
    }
});
it("Shuffle", async () => {
    await Crypto_1.ready;
    const len = 200;
    const shuffled = new Array(len);
    // Fill up with the indices
    for (let i = 0; i < len; i++) {
        shuffled[i] = i;
    }
    const indices = Helpers_1.shuffle(shuffled);
    // Unshuffle
    for (let i = 0; i < len; i++) {
        expect(shuffled[indices[i]]).toEqual(i);
    }
});
//# sourceMappingURL=Helpers.test.js.map