"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.numFromUint8Array = exports.numToUint8Array = exports.msgpackDecode = exports.msgpackEncode = exports.bufferUnpadFixed = exports.bufferPadFixed = exports.bufferUnpad = exports.bufferPad = exports.bufferPadSmall = exports.getPadding = exports.shuffle = exports.memcmp = exports.fromString = exports.toString = exports.fromBase64 = exports.toBase64 = exports.randomBytesDeterministic = exports.randomBytes = exports.symmetricNonceSize = exports.symmetricTagLength = exports.symmetricKeyLength = exports.sodium = void 0;
const msgpack = __importStar(require("@msgpack/msgpack"));
const libsodium_wrappers_1 = __importDefault(require("libsodium-wrappers"));
exports.sodium = libsodium_wrappers_1.default;
exports.symmetricKeyLength = 32; // sodium.crypto_aead_xchacha20poly1305_ietf_KEYBYTES;
exports.symmetricTagLength = 16; // sodium.crypto_aead_xchacha20poly1305_ietf_ABYTES;
exports.symmetricNonceSize = 24; // sodium.crypto_aead_xchacha20poly1305_ietf_NPUBBYTES;
function randomBytes(length) {
    return exports.sodium.randombytes_buf(length);
}
exports.randomBytes = randomBytes;
function randomBytesDeterministic(length, seed) {
    return exports.sodium.randombytes_buf_deterministic(length, seed);
}
exports.randomBytesDeterministic = randomBytesDeterministic;
function toBase64(input) {
    return exports.sodium.to_base64(input);
}
exports.toBase64 = toBase64;
function fromBase64(input) {
    return exports.sodium.from_base64(input);
}
exports.fromBase64 = fromBase64;
function toString(input) {
    return exports.sodium.to_string(input);
}
exports.toString = toString;
function fromString(input) {
    return exports.sodium.from_string(input);
}
exports.fromString = fromString;
function memcmp(b1, b2) {
    return exports.sodium.memcmp(b1, b2);
}
exports.memcmp = memcmp;
// Fisher–Yates shuffle - an unbiased shuffler
// The returend indices of where item is now.
// So if the first item moved to position 3: ret[0] = 3
function shuffle(a) {
    const len = a.length;
    const shuffledIndices = new Array(len);
    // Fill up with the indices
    for (let i = 0; i < len; i++) {
        shuffledIndices[i] = i;
    }
    for (let i = 0; i < len; i++) {
        const j = i + exports.sodium.randombytes_uniform(len - i);
        const tmp = a[i];
        a[i] = a[j];
        a[j] = tmp;
        // Also swap the index array
        const tmp2 = shuffledIndices[i];
        shuffledIndices[i] = shuffledIndices[j];
        shuffledIndices[j] = tmp2;
    }
    const ret = new Array(len);
    for (let i = 0; i < len; i++) {
        ret[shuffledIndices[i]] = i;
    }
    return ret;
}
exports.shuffle = shuffle;
function getPadding(length) {
    // Use the padme padding scheme for efficiently
    // https://www.petsymposium.org/2019/files/papers/issue4/popets-2019-0056.pdf
    // We want a minimum pad size of 4k
    if (length < (1 << 14)) {
        const size = (1 << 10) - 1;
        // We add 1 so we always have some padding
        return (length | size) + 1;
    }
    const e = Math.floor(Math.log2(length));
    const s = Math.floor(Math.log2(e)) + 1;
    const lastBits = e - s;
    const bitMask = Math.pow(2, lastBits) - 1;
    return (length + bitMask) & ~bitMask;
}
exports.getPadding = getPadding;
// FIXME: we should properly pad the meta and probably change these functions
// This function is the same as bufferPad, but doesn't enforce a large minimum padding size
function bufferPadSmall(buf) {
    return exports.sodium.pad(buf, buf.length + 1);
}
exports.bufferPadSmall = bufferPadSmall;
function bufferPad(buf) {
    return exports.sodium.pad(buf, getPadding(buf.length));
}
exports.bufferPad = bufferPad;
function bufferUnpad(buf) {
    if (buf.length === 0) {
        return buf;
    }
    // We pass the buffer's length as the block size because due to padme there's always some variable-sized padding.
    return exports.sodium.unpad(buf, buf.length);
}
exports.bufferUnpad = bufferUnpad;
function bufferPadFixed(buf, blocksize) {
    return exports.sodium.pad(buf, blocksize);
}
exports.bufferPadFixed = bufferPadFixed;
function bufferUnpadFixed(buf, blocksize) {
    return exports.sodium.unpad(buf, blocksize);
}
exports.bufferUnpadFixed = bufferUnpadFixed;
function msgpackEncode(value) {
    const options = { ignoreUndefined: true };
    return msgpack.encode(value, options);
}
exports.msgpackEncode = msgpackEncode;
function msgpackDecode(buffer) {
    return msgpack.decode(buffer);
}
exports.msgpackDecode = msgpackDecode;
function numToUint8Array(num) {
    // We are using little-endian because on most platforms it'll mean zero-conversion
    return Uint8Array.from([
        num & 255,
        (num >> 8) & 255,
        (num >> 16) & 255,
        (num >> 24) & 255,
    ]);
}
exports.numToUint8Array = numToUint8Array;
function numFromUint8Array(buf) {
    if (buf.length !== 4) {
        throw new Error("numFromUint8Array: buffer should be of length 4.");
    }
    return (buf[0] +
        (buf[1] << 8) +
        (buf[2] << 16) +
        (((buf[3] << 23) >>> 0) * 2));
}
exports.numFromUint8Array = numFromUint8Array;
//# sourceMappingURL=Helpers.js.map