import _sodium from "libsodium-wrappers";
export declare const sodium: typeof _sodium;
export declare type base64 = string;
export declare const symmetricKeyLength = 32;
export declare const symmetricTagLength = 16;
export declare const symmetricNonceSize = 24;
export declare function randomBytes(length: number): Uint8Array;
export declare function randomBytesDeterministic(length: number, seed: Uint8Array): Uint8Array;
export declare function toBase64(input: string | Uint8Array): string;
export declare function fromBase64(input: string): Uint8Array;
export declare function toString(input: Uint8Array): string;
export declare function fromString(input: string): Uint8Array;
export declare function memcmp(b1: Uint8Array, b2: Uint8Array): boolean;
export declare function shuffle<T>(a: T[]): number[];
export declare function getPadding(length: number): number;
export declare function bufferPadSmall(buf: Uint8Array): Uint8Array;
export declare function bufferPad(buf: Uint8Array): Uint8Array;
export declare function bufferUnpad(buf: Uint8Array): Uint8Array;
export declare function bufferPadFixed(buf: Uint8Array, blocksize: number): Uint8Array;
export declare function bufferUnpadFixed(buf: Uint8Array, blocksize: number): Uint8Array;
export declare function msgpackEncode(value: unknown): Uint8Array;
export declare function msgpackDecode(buffer: ArrayLike<number> | ArrayBuffer): unknown;
export declare function numToUint8Array(num: number): Uint8Array;
export declare function numFromUint8Array(buf: Uint8Array): number;
