import { ExtensionCodecType } from "./ExtensionCodec";
import { ExtData } from "./ExtData";
export declare const DEFAULT_MAX_DEPTH = 100;
export declare const DEFAULT_INITIAL_BUFFER_SIZE = 2048;
export declare class Encoder<ContextType> {
    readonly extensionCodec: ExtensionCodecType<ContextType>;
    readonly context: ContextType;
    readonly maxDepth: number;
    readonly initialBufferSize: number;
    readonly sortKeys: boolean;
    readonly forceFloat32: boolean;
    readonly ignoreUndefined: boolean;
    private pos;
    private view;
    private bytes;
    constructor(extensionCodec: ExtensionCodecType<ContextType>, context: ContextType, maxDepth?: number, initialBufferSize?: number, sortKeys?: boolean, forceFloat32?: boolean, ignoreUndefined?: boolean);
    encode(object: unknown, depth: number): void;
    getUint8Array(): Uint8Array;
    ensureBufferSizeToWrite(sizeToWrite: number): void;
    resizeBuffer(newSize: number): void;
    encodeNil(): void;
    encodeBoolean(object: boolean): void;
    encodeNumber(object: number): void;
    writeStringHeader(byteLength: number): void;
    encodeString(object: string): void;
    encodeObject(object: unknown, depth: number): void;
    encodeBinary(object: ArrayBufferView): void;
    encodeArray(object: Array<unknown>, depth: number): void;
    countWithoutUndefined(object: Record<string, unknown>, keys: ReadonlyArray<string>): number;
    encodeMap(object: Record<string, unknown>, depth: number): void;
    encodeExtension(ext: ExtData): void;
    writeU8(value: number): void;
    writeU8a(values: ArrayLike<number>): void;
    writeI8(value: number): void;
    writeU16(value: number): void;
    writeI16(value: number): void;
    writeU32(value: number): void;
    writeI32(value: number): void;
    writeF32(value: number): void;
    writeF64(value: number): void;
    writeU64(value: number): void;
    writeI64(value: number): void;
}
