"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const config_1 = require("@expo/config");
const paths_1 = require("@expo/config/paths");
const path_1 = __importDefault(require("path"));
const INTERNAL_CALLSITES_REGEX = new RegExp([
    '/Libraries/Renderer/implementations/.+\\.js$',
    '/Libraries/BatchedBridge/MessageQueue\\.js$',
    '/Libraries/YellowBox/.+\\.js$',
    '/Libraries/LogBox/.+\\.js$',
    '/Libraries/Core/Timers/.+\\.js$',
    '/node_modules/react-devtools-core/.+\\.js$',
    '/node_modules/react-refresh/.+\\.js$',
    '/node_modules/scheduler/.+\\.js$',
].join('|'));
function getDefaultConfig(projectRoot, options = {}) {
    var _a, _b;
    const { exp } = config_1.getConfig(projectRoot, { skipSDKVersionRequirement: true });
    const MetroConfig = importMetroConfigFromProject(projectRoot);
    const reactNativePath = path_1.default.dirname(config_1.resolveModule('react-native/package.json', projectRoot, exp));
    const target = (_b = (_a = options.target) !== null && _a !== void 0 ? _a : process.env.EXPO_TARGET) !== null && _b !== void 0 ? _b : config_1.getDefaultTarget(projectRoot);
    if (!(target === 'managed' || target === 'bare')) {
        throw new Error(`Invalid target: '${target}'. Debug info: \n${JSON.stringify({
            'options.target': options.target,
            EXPO_TARGET: process.env.EXPO_TARGET,
            default: config_1.getDefaultTarget(projectRoot),
        }, null, 2)}`);
    }
    const sourceExtsConfig = { isTS: true, isReact: true, isModern: false };
    const sourceExts = target === 'bare'
        ? paths_1.getBareExtensions([], sourceExtsConfig)
        : paths_1.getManagedExtensions([], sourceExtsConfig);
    const metroDefaultValues = MetroConfig.getDefaultConfig.getDefaultValues(projectRoot);
    // Merge in the default config from Metro here, even though loadConfig uses it as defaults.
    // This is a convenience for getDefaultConfig use in metro.config.js, e.g. to modify assetExts.
    return MetroConfig.mergeConfig(metroDefaultValues, {
        resolver: {
            resolverMainFields: ['react-native', 'browser', 'main'],
            platforms: ['ios', 'android', 'native'],
            sourceExts,
        },
        serializer: {
            getModulesRunBeforeMainModule: () => [
                require.resolve(path_1.default.join(reactNativePath, 'Libraries/Core/InitializeCore')),
            ],
            getPolyfills: () => require(path_1.default.join(reactNativePath, 'rn-get-polyfills'))(),
        },
        symbolicator: {
            customizeFrame: (frame) => {
                const collapse = Boolean(frame.file && INTERNAL_CALLSITES_REGEX.test(frame.file));
                return { collapse };
            },
        },
        transformer: {
            babelTransformerPath: require.resolve('metro-react-native-babel-transformer'),
            // TODO: Bacon: Add path for web platform
            assetRegistryPath: path_1.default.join(reactNativePath, 'Libraries/Image/AssetRegistry'),
            assetPlugins: [config_1.resolveModule('expo-asset/tools/hashAssetFiles', projectRoot, exp)],
        },
    });
}
exports.getDefaultConfig = getDefaultConfig;
async function loadAsync(projectRoot, _a = {}) {
    var { reporter, target } = _a, metroOptions = __rest(_a, ["reporter", "target"]);
    let defaultConfig = getDefaultConfig(projectRoot, { target });
    if (reporter) {
        defaultConfig = Object.assign(Object.assign({}, defaultConfig), { reporter });
    }
    const MetroConfig = importMetroConfigFromProject(projectRoot);
    return await MetroConfig.loadConfig(Object.assign({ cwd: projectRoot, projectRoot }, metroOptions), defaultConfig);
}
exports.loadAsync = loadAsync;
function importMetroConfigFromProject(projectRoot) {
    const { exp } = config_1.getConfig(projectRoot, { skipSDKVersionRequirement: true });
    const resolvedPath = config_1.projectHasModule('metro-config', projectRoot, exp);
    if (!resolvedPath) {
        throw new Error('Missing package "metro-config" in the project. ' +
            'This usually means `react-native` is not installed. ' +
            'Please verify that dependencies in package.json include "react-native" ' +
            'and run `yarn` or `npm install`.');
    }
    return require(resolvedPath);
}
//# sourceMappingURL=ExpoMetroConfig.js.map