import xcode, { PBXGroup, PBXNativeTarget, PBXProject, XCBuildConfiguration, XCConfigurationList, XcodeProject } from 'xcode';
export declare type ProjectSectionEntry = [string, PBXProject];
export declare type NativeTargetSection = Record<string, PBXNativeTarget>;
export declare type NativeTargetSectionEntry = [string, PBXNativeTarget];
export declare type ConfigurationLists = Record<string, XCConfigurationList>;
export declare type ConfigurationListEntry = [string, XCConfigurationList];
export declare type ConfigurationSectionEntry = [string, XCBuildConfiguration];
export declare function getProjectName(projectRoot: string): string;
export declare function getSourceRoot(projectRoot: string): string;
export declare function addFileToGroup(filepath: string, groupName: string, project: XcodeProject): XcodeProject;
export declare function ensureGroupRecursively(project: XcodeProject, filepath: string): PBXGroup | null;
export declare function findSchemeNames(projectRoot: string): string[];
/**
 * Get the pbxproj for the given path
 */
export declare function getPbxproj(projectRoot: string): XcodeProject;
export declare function getProjectSection(project: XcodeProject): Record<string, xcode.PBXProject> & Record<string, string>;
export declare function getNativeTargets(project: XcodeProject): NativeTargetSectionEntry[];
export declare function findFirstNativeTarget(project: XcodeProject): PBXNativeTarget;
export declare function getXCConfigurationListEntries(project: XcodeProject): ConfigurationListEntry[];
export declare function getBuildConfigurationForId(project: XcodeProject, configurationListId: string): ConfigurationSectionEntry[];
export declare function isBuildConfig([, sectionItem]: ConfigurationSectionEntry): boolean;
export declare function isNotTestHost([, sectionItem]: ConfigurationSectionEntry): boolean;
export declare function isNotComment([key]: ConfigurationSectionEntry | ProjectSectionEntry | ConfigurationListEntry | NativeTargetSectionEntry): boolean;
