"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function getUpdateUrl(config, username) {
    const user = typeof config.owner === 'string' ? config.owner : username;
    if (!user) {
        return undefined;
    }
    return `https://exp.host/@${user}/${config.slug}`;
}
exports.getUpdateUrl = getUpdateUrl;
function getSDKVersion(config) {
    return typeof config.sdkVersion === 'string' ? config.sdkVersion : null;
}
exports.getSDKVersion = getSDKVersion;
function getUpdatesEnabled(config) {
    var _a;
    return ((_a = config.updates) === null || _a === void 0 ? void 0 : _a.enabled) !== false;
}
exports.getUpdatesEnabled = getUpdatesEnabled;
function getUpdatesTimeout(config) {
    var _a, _b;
    return (_b = (_a = config.updates) === null || _a === void 0 ? void 0 : _a.fallbackToCacheTimeout) !== null && _b !== void 0 ? _b : 0;
}
exports.getUpdatesTimeout = getUpdatesTimeout;
function getUpdatesCheckOnLaunch(config) {
    var _a, _b;
    if (((_a = config.updates) === null || _a === void 0 ? void 0 : _a.checkAutomatically) === 'ON_ERROR_RECOVERY') {
        return 'NEVER';
    }
    else if (((_b = config.updates) === null || _b === void 0 ? void 0 : _b.checkAutomatically) === 'ON_LOAD') {
        return 'ALWAYS';
    }
    return 'ALWAYS';
}
exports.getUpdatesCheckOnLaunch = getUpdatesCheckOnLaunch;
function setUpdatesConfig(config, expoPlist, username) {
    let newExpoPlist = Object.assign(Object.assign({}, expoPlist), { EXUpdatesEnabled: getUpdatesEnabled(config), EXUpdatesURL: getUpdateUrl(config, username), EXUpdatesCheckOnLaunch: getUpdatesCheckOnLaunch(config), EXUpdatesLaunchWaitMs: getUpdatesTimeout(config) });
    const updateUrl = getUpdateUrl(config, username);
    if (updateUrl) {
        newExpoPlist = Object.assign(Object.assign({}, newExpoPlist), { EXUpdatesURL: updateUrl });
    }
    const sdkVersion = getSDKVersion(config);
    if (sdkVersion) {
        newExpoPlist = Object.assign(Object.assign({}, newExpoPlist), { EXUpdatesSDKVersion: sdkVersion });
    }
    return newExpoPlist;
}
exports.setUpdatesConfig = setUpdatesConfig;
//# sourceMappingURL=Updates.js.map