import { ExpoConfig } from '../Config.types';
import { InfoPlist } from './IosConfig.types';
export declare function getName(config: ExpoConfig): string | null;
/**
 * CFBundleDisplayName is used for most things: the name on the home screen, in
 * notifications, and others.
 */
export declare function setDisplayName(configOrName: ExpoConfig | string, { CFBundleDisplayName, ...infoPlist }: InfoPlist): {
    CFBundleShortVersionString?: string | undefined;
    CFBundleVersion?: string | undefined;
    CFBundleIdentifier?: string | undefined;
    CFBundleName?: string | undefined;
    CFBundleURLTypes?: import("./IosConfig.types").URLScheme[] | undefined;
    ITSAppUsesNonExemptEncryption?: boolean | undefined;
    LSApplicationQueriesSchemes?: string[] | undefined;
    FacebookAppID?: string | undefined;
    FacebookDisplayName?: string | undefined;
    FacebookAutoInitEnabled?: boolean | undefined;
    FacebookAutoLogAppEventsEnabled?: boolean | undefined;
    FacebookAdvertiserIDCollectionEnabled?: boolean | undefined;
    UISupportedInterfaceOrientations?: import("./IosConfig.types").InterfaceOrientation[] | undefined;
    GMSApiKey?: string | undefined;
    GADApplicationIdentifier?: string | undefined;
    UIUserInterfaceStyle?: string | undefined;
} | {
    CFBundleDisplayName: string;
    CFBundleShortVersionString?: string | undefined;
    CFBundleVersion?: string | undefined;
    CFBundleIdentifier?: string | undefined;
    CFBundleName?: string | undefined;
    CFBundleURLTypes?: import("./IosConfig.types").URLScheme[] | undefined;
    ITSAppUsesNonExemptEncryption?: boolean | undefined;
    LSApplicationQueriesSchemes?: string[] | undefined;
    FacebookAppID?: string | undefined;
    FacebookDisplayName?: string | undefined;
    FacebookAutoInitEnabled?: boolean | undefined;
    FacebookAutoLogAppEventsEnabled?: boolean | undefined;
    FacebookAdvertiserIDCollectionEnabled?: boolean | undefined;
    UISupportedInterfaceOrientations?: import("./IosConfig.types").InterfaceOrientation[] | undefined;
    GMSApiKey?: string | undefined;
    GADApplicationIdentifier?: string | undefined;
    UIUserInterfaceStyle?: string | undefined;
};
/**
 * CFBundleName is recommended to be 16 chars or less and is used in lists, eg:
 * sometimes on the App Store
 */
export declare function setName(config: ExpoConfig, { CFBundleName, ...infoPlist }: InfoPlist): {
    CFBundleShortVersionString?: string | undefined;
    CFBundleVersion?: string | undefined;
    CFBundleDisplayName?: string | undefined;
    CFBundleIdentifier?: string | undefined;
    CFBundleURLTypes?: import("./IosConfig.types").URLScheme[] | undefined;
    ITSAppUsesNonExemptEncryption?: boolean | undefined;
    LSApplicationQueriesSchemes?: string[] | undefined;
    FacebookAppID?: string | undefined;
    FacebookDisplayName?: string | undefined;
    FacebookAutoInitEnabled?: boolean | undefined;
    FacebookAutoLogAppEventsEnabled?: boolean | undefined;
    FacebookAdvertiserIDCollectionEnabled?: boolean | undefined;
    UISupportedInterfaceOrientations?: import("./IosConfig.types").InterfaceOrientation[] | undefined;
    GMSApiKey?: string | undefined;
    GADApplicationIdentifier?: string | undefined;
    UIUserInterfaceStyle?: string | undefined;
} | {
    CFBundleName: string;
    CFBundleShortVersionString?: string | undefined;
    CFBundleVersion?: string | undefined;
    CFBundleDisplayName?: string | undefined;
    CFBundleIdentifier?: string | undefined;
    CFBundleURLTypes?: import("./IosConfig.types").URLScheme[] | undefined;
    ITSAppUsesNonExemptEncryption?: boolean | undefined;
    LSApplicationQueriesSchemes?: string[] | undefined;
    FacebookAppID?: string | undefined;
    FacebookDisplayName?: string | undefined;
    FacebookAutoInitEnabled?: boolean | undefined;
    FacebookAutoLogAppEventsEnabled?: boolean | undefined;
    FacebookAdvertiserIDCollectionEnabled?: boolean | undefined;
    UISupportedInterfaceOrientations?: import("./IosConfig.types").InterfaceOrientation[] | undefined;
    GMSApiKey?: string | undefined;
    GADApplicationIdentifier?: string | undefined;
    UIUserInterfaceStyle?: string | undefined;
};
