"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const fs_extra_1 = __importDefault(require("fs-extra"));
const glob_1 = require("glob");
const path_1 = __importDefault(require("path"));
const WarningAggregator_1 = require("../WarningAggregator");
const Xcodeproj_1 = require("./utils/Xcodeproj");
// TODO: should it be possible to turn off these entitlements by setting false in app.json and running apply
function getConfigEntitlements(config) {
    var _a, _b;
    return (_b = (_a = config.ios) === null || _a === void 0 ? void 0 : _a.entitlements) !== null && _b !== void 0 ? _b : {};
}
exports.getConfigEntitlements = getConfigEntitlements;
function setCustomEntitlementsEntries(config, entitlements) {
    const entries = getConfigEntitlements(config);
    return Object.assign(Object.assign({}, entitlements), entries);
}
exports.setCustomEntitlementsEntries = setCustomEntitlementsEntries;
function setICloudEntitlement(config, appleTeamId, entitlementsPlist) {
    var _a;
    if ((_a = config.ios) === null || _a === void 0 ? void 0 : _a.usesIcloudStorage) {
        // TODO: need access to the appleTeamId for this one!
        WarningAggregator_1.addWarningIOS('ios.usesIcloudStorage', 'Enable the iCloud Storage Entitlement from the Capabilities tab in your Xcode project.'
        // TODO: add a link to a docs page with more information on how to do this
        );
    }
    return entitlementsPlist;
}
exports.setICloudEntitlement = setICloudEntitlement;
function setAppleSignInEntitlement(config, _a) {
    var _b;
    var { 'com.apple.developer.applesignin': _ } = _a, entitlementsPlist = __rest(_a, ['com.apple.developer.applesignin']);
    if ((_b = config.ios) === null || _b === void 0 ? void 0 : _b.usesAppleSignIn) {
        return Object.assign(Object.assign({}, entitlementsPlist), { 'com.apple.developer.applesignin': ['Default'] });
    }
    return entitlementsPlist;
}
exports.setAppleSignInEntitlement = setAppleSignInEntitlement;
function setAccessesContactNotes(config, _a) {
    var _b;
    var { 'com.apple.developer.contacts.notes': _ } = _a, entitlementsPlist = __rest(_a, ['com.apple.developer.contacts.notes']);
    if ((_b = config.ios) === null || _b === void 0 ? void 0 : _b.accessesContactNotes) {
        return Object.assign(Object.assign({}, entitlementsPlist), { 'com.apple.developer.contacts.notes': config.ios.accessesContactNotes });
    }
    return entitlementsPlist;
}
exports.setAccessesContactNotes = setAccessesContactNotes;
function setAssociatedDomains(config, _a) {
    var _b;
    var { 'com.apple.developer.associated-domains': _ } = _a, entitlementsPlist = __rest(_a, ['com.apple.developer.associated-domains']);
    if ((_b = config.ios) === null || _b === void 0 ? void 0 : _b.associatedDomains) {
        return Object.assign(Object.assign({}, entitlementsPlist), { 'com.apple.developer.associated-domains': config.ios.associatedDomains });
    }
    return entitlementsPlist;
}
exports.setAssociatedDomains = setAssociatedDomains;
function getEntitlementsPath(projectRoot) {
    var _a;
    return (_a = getExistingEntitlementsPath(projectRoot)) !== null && _a !== void 0 ? _a : createEntitlementsFile(projectRoot);
}
exports.getEntitlementsPath = getEntitlementsPath;
function createEntitlementsFile(projectRoot) {
    /**
     * Write file from template
     */
    const entitlementsPath = getDefaultEntitlementsPath(projectRoot);
    if (!fs_extra_1.default.pathExistsSync(path_1.default.dirname(entitlementsPath))) {
        fs_extra_1.default.mkdirSync(path_1.default.dirname(entitlementsPath));
    }
    fs_extra_1.default.writeFileSync(entitlementsPath, ENTITLEMENTS_TEMPLATE);
    const entitlementsRelativePath = entitlementsPath.replace(`${projectRoot}/ios/`, '');
    /**
     * Add file to pbxproj under CODE_SIGN_ENTITLEMENTS
     */
    const project = Xcodeproj_1.getPbxproj(projectRoot);
    Object.entries(project.pbxXCBuildConfigurationSection())
        .filter(Xcodeproj_1.isNotComment)
        .filter(Xcodeproj_1.isBuildConfig)
        .filter(Xcodeproj_1.isNotTestHost)
        .forEach(({ 1: { buildSettings } }) => {
        buildSettings.CODE_SIGN_ENTITLEMENTS = entitlementsRelativePath;
    });
    fs_extra_1.default.writeFileSync(project.filepath, project.writeSync());
    return entitlementsPath;
}
function getDefaultEntitlementsPath(projectRoot) {
    const projectName = Xcodeproj_1.getProjectName(projectRoot);
    const project = Xcodeproj_1.getPbxproj(projectRoot);
    const productName = project.productName;
    return path_1.default.join(projectRoot, 'ios', projectName, `${productName}.entitlements`);
}
const ENTITLEMENTS_TEMPLATE = `
<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE plist PUBLIC "-//Apple//DTD PLIST 1.0//EN" "http://www.apple.com/DTDs/PropertyList-1.0.dtd">
<plist version="1.0">
<dict>
</dict>
</plist>
`;
/**
 * Get the path to an existing entitlements file or use the default
 */
function getExistingEntitlementsPath(projectRoot) {
    const entitlementsPaths = glob_1.sync('ios/*/.entitlements', { absolute: true, cwd: projectRoot });
    if (entitlementsPaths.length === 0) {
        return null;
    }
    const [entitlementsPath, ...otherEntitlementsPaths] = entitlementsPaths[0];
    if (entitlementsPaths.length > 1) {
        console.warn(`Found multiple entitlements paths, using ${entitlementsPath}. Other paths ${JSON.stringify(otherEntitlementsPaths)} ignored.`);
    }
    return entitlementsPath;
}
//# sourceMappingURL=Entitlements.js.map