import { ExpoConfig } from '../Config.types';
import { InfoPlist } from './IosConfig.types';
declare type Plist = Record<string, any>;
export declare function getConfigEntitlements(config: ExpoConfig): {
    [k: string]: any;
};
export declare function setCustomEntitlementsEntries(config: ExpoConfig, entitlements: InfoPlist): {
    CFBundleShortVersionString?: string | undefined;
    CFBundleVersion?: string | undefined;
    CFBundleDisplayName?: string | undefined;
    CFBundleIdentifier?: string | undefined;
    CFBundleName?: string | undefined;
    CFBundleURLTypes?: import("./IosConfig.types").URLScheme[] | undefined;
    ITSAppUsesNonExemptEncryption?: boolean | undefined;
    LSApplicationQueriesSchemes?: string[] | undefined;
    FacebookAppID?: string | undefined;
    FacebookDisplayName?: string | undefined;
    FacebookAutoInitEnabled?: boolean | undefined;
    FacebookAutoLogAppEventsEnabled?: boolean | undefined;
    FacebookAdvertiserIDCollectionEnabled?: boolean | undefined;
    UISupportedInterfaceOrientations?: import("./IosConfig.types").InterfaceOrientation[] | undefined;
    GMSApiKey?: string | undefined;
    GADApplicationIdentifier?: string | undefined;
    UIUserInterfaceStyle?: string | undefined;
};
export declare function setICloudEntitlement(config: ExpoConfig, appleTeamId: string, entitlementsPlist: Plist): Plist;
export declare function setAppleSignInEntitlement(config: ExpoConfig, { 'com.apple.developer.applesignin': _, ...entitlementsPlist }: Plist): Plist;
export declare function setAccessesContactNotes(config: ExpoConfig, { 'com.apple.developer.contacts.notes': _, ...entitlementsPlist }: Plist): Plist;
export declare function setAssociatedDomains(config: ExpoConfig, { 'com.apple.developer.associated-domains': _, ...entitlementsPlist }: Plist): Plist;
export declare function getEntitlementsPath(projectRoot: string): string;
export {};
