import { ExpoConfig } from '../Config.types';
export declare function getSupportsTablet(config: ExpoConfig): boolean;
export declare function getIsTabletOnly(config: ExpoConfig): boolean;
export declare function getDeviceFamilies(config: ExpoConfig): number[];
/**
 * Wrapping the families in double quotes is the only way to set a value with a comma in it.
 * Use a number when only value is returned, this better emulates Xcode.
 *
 * @param deviceFamilies
 */
export declare function formatDeviceFamilies(deviceFamilies: number[]): string | number;
/**
 * Add to pbxproj under TARGETED_DEVICE_FAMILY
 */
export declare function setDeviceFamily(config: ExpoConfig, projectRoot: string): void;
