"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const Manifest_1 = require("./Manifest");
function getUpdateUrl(config, username) {
    const user = typeof config.owner === 'string' ? config.owner : username;
    if (!user) {
        return null;
    }
    return `https://exp.host/@${user}/${config.slug}`;
}
exports.getUpdateUrl = getUpdateUrl;
function getSDKVersion(config) {
    return typeof config.sdkVersion === 'string' ? config.sdkVersion : null;
}
exports.getSDKVersion = getSDKVersion;
function getUpdatesEnabled(config) {
    var _a;
    return ((_a = config.updates) === null || _a === void 0 ? void 0 : _a.enabled) !== false;
}
exports.getUpdatesEnabled = getUpdatesEnabled;
function getUpdatesTimeout(config) {
    var _a, _b;
    return (_b = (_a = config.updates) === null || _a === void 0 ? void 0 : _a.fallbackToCacheTimeout) !== null && _b !== void 0 ? _b : 0;
}
exports.getUpdatesTimeout = getUpdatesTimeout;
function getUpdatesCheckOnLaunch(config) {
    var _a, _b;
    if (((_a = config.updates) === null || _a === void 0 ? void 0 : _a.checkAutomatically) === 'ON_ERROR_RECOVERY') {
        return 'NEVER';
    }
    else if (((_b = config.updates) === null || _b === void 0 ? void 0 : _b.checkAutomatically) === 'ON_LOAD') {
        return 'ALWAYS';
    }
    return 'ALWAYS';
}
exports.getUpdatesCheckOnLaunch = getUpdatesCheckOnLaunch;
async function setUpdatesConfig(config, manifestDocument, username) {
    const mainApplication = Manifest_1.getMainApplication(manifestDocument);
    Manifest_1.addMetaDataItemToMainApplication(mainApplication, 'expo.modules.updates.ENABLED', `${getUpdatesEnabled(config)}`);
    Manifest_1.addMetaDataItemToMainApplication(mainApplication, 'expo.modules.updates.EXPO_UPDATES_CHECK_ON_LAUNCH', getUpdatesCheckOnLaunch(config));
    Manifest_1.addMetaDataItemToMainApplication(mainApplication, 'expo.modules.updates.EXPO_UPDATES_LAUNCH_WAIT_MS', `${getUpdatesTimeout(config)}`);
    const updateUrl = getUpdateUrl(config, username);
    if (updateUrl) {
        Manifest_1.addMetaDataItemToMainApplication(mainApplication, 'expo.modules.updates.EXPO_UPDATE_URL', updateUrl);
    }
    const sdkVersion = getSDKVersion(config);
    if (sdkVersion) {
        Manifest_1.addMetaDataItemToMainApplication(mainApplication, 'expo.modules.updates.EXPO_SDK_VERSION', sdkVersion);
    }
    return manifestDocument;
}
exports.setUpdatesConfig = setUpdatesConfig;
//# sourceMappingURL=Updates.js.map