"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const Colors_1 = require("./Colors");
const Resources_1 = require("./Resources");
const Styles_1 = require("./Styles");
const XML_1 = require("./XML");
const ANDROID_WINDOW_BACKGROUND = 'android:windowBackground';
const WINDOW_BACKGROUND_COLOR = 'activityBackground';
function getRootViewBackgroundColor(config) {
    var _a;
    if ((_a = config.android) === null || _a === void 0 ? void 0 : _a.backgroundColor) {
        return config.android.backgroundColor;
    }
    if (config.backgroundColor) {
        return config.backgroundColor;
    }
    return null;
}
exports.getRootViewBackgroundColor = getRootViewBackgroundColor;
async function setRootViewBackgroundColor(config, projectDirectory) {
    const hexString = getRootViewBackgroundColor(config);
    if (!hexString) {
        return false;
    }
    const stylesPath = await Styles_1.getProjectStylesXMLPathAsync(projectDirectory);
    const colorsPath = await Colors_1.getProjectColorsXMLPathAsync(projectDirectory);
    let stylesJSON = await Resources_1.readResourcesXMLAsync({ path: stylesPath });
    let colorsJSON = await Resources_1.readResourcesXMLAsync({ path: colorsPath });
    const colorItemToAdd = Resources_1.buildResourceItem({ name: WINDOW_BACKGROUND_COLOR, value: hexString });
    const styleItemToAdd = Resources_1.buildResourceItem({
        name: ANDROID_WINDOW_BACKGROUND,
        value: `@color/${WINDOW_BACKGROUND_COLOR}`,
    });
    colorsJSON = Colors_1.setColorItem(colorItemToAdd, colorsJSON);
    stylesJSON = Styles_1.setStylesItem({
        item: styleItemToAdd,
        xml: stylesJSON,
        parent: { name: 'AppTheme', parent: 'Theme.AppCompat.Light.NoActionBar' },
    });
    try {
        await Promise.all([
            XML_1.writeXMLAsync({ path: colorsPath, xml: colorsJSON }),
            XML_1.writeXMLAsync({ path: stylesPath, xml: stylesJSON }),
        ]);
    }
    catch (e) {
        throw new Error(`Error setting Android root view background color. Cannot write new styles.xml to ${stylesPath}.`);
    }
    return true;
}
exports.setRootViewBackgroundColor = setRootViewBackgroundColor;
//# sourceMappingURL=RootViewBackgroundColor.js.map