"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const Manifest_1 = require("./Manifest");
function getGoogleMobileAdsAppId(config) {
    var _a, _b, _c;
    return (_c = (_b = (_a = config.android) === null || _a === void 0 ? void 0 : _a.config) === null || _b === void 0 ? void 0 : _b.googleMobileAdsAppId) !== null && _c !== void 0 ? _c : null;
}
exports.getGoogleMobileAdsAppId = getGoogleMobileAdsAppId;
function getGoogleMobileAdsAutoInit(config) {
    var _a, _b, _c;
    return (_c = (_b = (_a = config.android) === null || _a === void 0 ? void 0 : _a.config) === null || _b === void 0 ? void 0 : _b.googleMobileAdsAutoInit) !== null && _c !== void 0 ? _c : false;
}
exports.getGoogleMobileAdsAutoInit = getGoogleMobileAdsAutoInit;
async function setGoogleMobileAdsConfig(config, manifestDocument) {
    const appId = getGoogleMobileAdsAppId(config);
    const autoInit = getGoogleMobileAdsAutoInit(config);
    if (!appId) {
        return manifestDocument;
    }
    let mainApplication = Manifest_1.getMainApplication(manifestDocument);
    if (!mainApplication) {
        mainApplication = { $: { 'android:name': '.MainApplication' } };
    }
    // add application ID
    let existingApplicationId;
    const newApplicationId = {
        $: {
            'android:name': 'com.google.android.gms.ads.APPLICATION_ID',
            'android:value': appId,
        },
    };
    if (mainApplication['meta-data']) {
        existingApplicationId = mainApplication['meta-data'].filter((e) => e['$']['android:name'] === 'com.google.android.gms.ads.APPLICATION_ID');
        if (existingApplicationId.length) {
            existingApplicationId[0]['$']['android:value'] = appId;
        }
        else {
            mainApplication['meta-data'].push(newApplicationId);
        }
    }
    else {
        mainApplication['meta-data'] = [newApplicationId];
    }
    // add delay auto init
    let existingDelayAutoInit;
    const newDelayAutoInit = {
        $: {
            'android:name': 'com.google.android.gms.ads.DELAY_APP_MEASUREMENT_INIT',
            'android:value': String(!autoInit),
        },
    };
    if (mainApplication['meta-data']) {
        existingDelayAutoInit = mainApplication['meta-data'].filter((e) => e['$']['android:name'] === 'com.google.android.gms.ads.DELAY_APP_MEASUREMENT_INIT');
        if (existingDelayAutoInit.length) {
            existingDelayAutoInit[0]['$']['android:value'] = String(!autoInit);
        }
        else {
            mainApplication['meta-data'].push(newDelayAutoInit);
        }
    }
    else {
        mainApplication['meta-data'] = [newDelayAutoInit];
    }
    return manifestDocument;
}
exports.setGoogleMobileAdsConfig = setGoogleMobileAdsConfig;
//# sourceMappingURL=GoogleMobileAds.js.map