"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const Errors_1 = require("./Errors");
function serializeAndEvaluate(val) {
    if (['undefined', 'string', 'boolean', 'number', 'bigint'].includes(typeof val)) {
        return val;
    }
    else if (typeof val === 'function') {
        // TODO: Bacon: Should we support async methods?
        return val();
    }
    else if (Array.isArray(val)) {
        return val.map(serializeAndEvaluate);
    }
    else if (typeof val === 'object') {
        const output = {};
        for (const property in val) {
            if (val.hasOwnProperty(property)) {
                output[property] = serializeAndEvaluate(val[property]);
            }
        }
        return output;
    }
    // symbol
    throw new Errors_1.ConfigError(`Expo config doesn't support \`Symbols\`: ${val}`, 'INVALID_CONFIG');
}
exports.serializeAndEvaluate = serializeAndEvaluate;
//# sourceMappingURL=Serialize.js.map