"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Based on `JsonFileError` from `@expo/json-file`
 */
class ConfigError extends Error {
    constructor(message, code, cause) {
        super(cause ? `${message}\n└─ Cause: ${cause.name}: ${cause.message}` : message);
        this.code = code;
        this.cause = cause;
        this.name = this.constructor.name;
    }
}
exports.ConfigError = ConfigError;
function errorFromJSON(_a) {
    var { name } = _a, json = __rest(_a, ["name"]);
    let error;
    if (name === 'TypeError') {
        error = new TypeError(json.message);
    }
    else {
        error = new Error(json.message);
    }
    for (const key of Object.keys(json)) {
        if (key in json) {
            error[key] = json[key];
        }
    }
    return error;
}
exports.errorFromJSON = errorFromJSON;
function errorToJSON(error) {
    return Object.assign(Object.assign({}, error), { message: error.message, code: error.code, name: error.name, stack: error.stack });
}
exports.errorToJSON = errorToJSON;
//# sourceMappingURL=Errors.js.map