"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.min = exports.max = exports.floor = exports.ceil = exports.abs = exports.atan = exports.asin = exports.acos = exports.tan = exports.not = exports.defined = exports.or = exports.and = exports.neq = exports.greaterOrEq = exports.lessOrEq = exports.greaterThan = exports.eq = exports.lessThan = exports.round = exports.exp = exports.cos = exports.sin = exports.log = exports.sqrt = exports.modulo = exports.pow = exports.divide = exports.multiply = exports.sub = exports.add = void 0;

var _AnimatedOperator = require("./core/AnimatedOperator");

const operator = _AnimatedOperator.createAnimatedOperator;
const add = operator('add');
exports.add = add;
const sub = operator('sub');
exports.sub = sub;
const multiply = operator('multiply');
exports.multiply = multiply;
const divide = operator('divide');
exports.divide = divide;
const pow = operator('pow');
exports.pow = pow;
const modulo = operator('modulo');
exports.modulo = modulo;
const sqrt = operator('sqrt');
exports.sqrt = sqrt;
const log = operator('log');
exports.log = log;
const sin = operator('sin');
exports.sin = sin;
const cos = operator('cos');
exports.cos = cos;
const exp = operator('exp');
exports.exp = exp;
const round = operator('round');
exports.round = round;
const lessThan = operator('lessThan');
exports.lessThan = lessThan;
const eq = operator('eq');
exports.eq = eq;
const greaterThan = operator('greaterThan');
exports.greaterThan = greaterThan;
const lessOrEq = operator('lessOrEq');
exports.lessOrEq = lessOrEq;
const greaterOrEq = operator('greaterOrEq');
exports.greaterOrEq = greaterOrEq;
const neq = operator('neq');
exports.neq = neq;
const and = operator('and');
exports.and = and;
const or = operator('or');
exports.or = or;
const defined = operator('defined');
exports.defined = defined;
const not = operator('not');
exports.not = not;
const tan = operator('tan');
exports.tan = tan;
const acos = operator('acos');
exports.acos = acos;
const asin = operator('asin');
exports.asin = asin;
const atan = operator('atan');
exports.atan = atan;
const abs = operator('abs');
exports.abs = abs;
const ceil = operator('ceil');
exports.ceil = ceil;
const floor = operator('floor');
exports.floor = floor;
const max = operator('max');
exports.max = max;
const min = operator('min');
exports.min = min;
//# sourceMappingURL=operators.js.map