"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MenuItem = exports.default = void 0;

var _color = _interopRequireDefault(require("color"));

var React = _interopRequireWildcard(require("react"));

var _reactNative = require("react-native");

var _Icon = _interopRequireDefault(require("../Icon"));

var _TouchableRipple = _interopRequireDefault(require("../TouchableRipple/TouchableRipple"));

var _Text = _interopRequireDefault(require("../Typography/Text"));

var _theming = require("../../core/theming");

var _colors = require("../../styles/colors");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/**
 * A component to show a single list item inside a Menu.
 *
 * <div class="screenshots">
 *   <figure>
 *     <img class="medium" src="screenshots/menu-item.png" />
 *   </figure>
 * </div>
 *
 * ## Usage
 * ```js
 * import * as React from 'react';
 * import { View } from 'react-native';
 * import { Menu } from 'react-native-paper';
 *
 * const MyComponent = () => (
 *   <View style={{ flex: 1 }}>
 *     <Menu.Item icon="redo" onPress={() => {}} title="Redo" />
 *     <Menu.Item icon="undo" onPress={() => {}} title="Undo" />
 *     <Menu.Item icon="content-cut" onPress={() => {}} title="Cut" disabled />
 *     <Menu.Item icon="content-copy" onPress={() => {}} title="Copy" disabled />
 *     <Menu.Item icon="content-paste" onPress={() => {}} title="Paste" />
 *   </View>
 * );
 *
 * export default MyComponent;
 * ```
 */
class MenuItem extends React.Component {
  render() {
    const {
      icon,
      title,
      disabled,
      onPress,
      theme,
      style,
      testID,
      titleStyle
    } = this.props;
    const disabledColor = (0, _color.default)(theme.dark ? _colors.white : _colors.black).alpha(0.32).rgb().string();
    const titleColor = disabled ? disabledColor : (0, _color.default)(theme.colors.text).alpha(0.87).rgb().string();
    const iconColor = disabled ? disabledColor : (0, _color.default)(theme.colors.text).alpha(0.54).rgb().string();
    return /*#__PURE__*/React.createElement(_TouchableRipple.default, {
      style: [styles.container, style],
      onPress: onPress,
      disabled: disabled,
      testID: testID
    }, /*#__PURE__*/React.createElement(_reactNative.View, {
      style: styles.row
    }, icon ? /*#__PURE__*/React.createElement(_reactNative.View, {
      style: [styles.item, styles.icon],
      pointerEvents: "box-none"
    }, /*#__PURE__*/React.createElement(_Icon.default, {
      source: icon,
      size: 24,
      color: iconColor
    })) : null, /*#__PURE__*/React.createElement(_reactNative.View, {
      style: [styles.item, styles.content, icon ? styles.widthWithIcon : null],
      pointerEvents: "none"
    }, /*#__PURE__*/React.createElement(_Text.default, {
      numberOfLines: 1,
      style: [styles.title, {
        color: titleColor
      }, titleStyle]
    }, title))));
  }

}

exports.MenuItem = MenuItem;

_defineProperty(MenuItem, "displayName", 'Menu.Item');

const minWidth = 112;
const maxWidth = 280;
const iconWidth = 40;

const styles = _reactNative.StyleSheet.create({
  container: {
    paddingHorizontal: 8,
    minWidth,
    maxWidth,
    height: 48,
    justifyContent: 'center'
  },
  row: {
    flexDirection: 'row'
  },
  icon: {
    width: iconWidth
  },
  title: {
    fontSize: 16
  },
  item: {
    marginHorizontal: 8
  },
  content: {
    justifyContent: 'center',
    minWidth: minWidth - 16,
    maxWidth: maxWidth - 16
  },
  widthWithIcon: {
    maxWidth: maxWidth - (iconWidth + 48)
  }
});

var _default = (0, _theming.withTheme)(MenuItem); // @component-docs ignore-next-line


exports.default = _default;
//# sourceMappingURL=MenuItem.js.map