import { BoxCryptoManager } from "./Crypto";
export { ready, getPrettyFingerprint, _setRnSodium } from "./Crypto";
export * from "./Exceptions";
import { base64 } from "./Helpers";
export { base64, fromBase64, toBase64, randomBytes } from "./Helpers";
import { CollectionAccessLevel, CollectionCryptoManager, CollectionItemCryptoManager, ItemMetadata, EncryptedCollection, EncryptedCollectionItem } from "./EncryptedModels";
export * from "./EncryptedModels";
import { FetchOptions, ItemFetchOptions, LoginResponseUser, User, MemberFetchOptions, InvitationFetchOptions, RevisionsFetchOptions } from "./OnlineManagers";
export { User, CollectionMember, FetchOptions, ItemFetchOptions } from "./OnlineManagers";
export { CURRENT_VERSION } from "./Constants";
export interface AccountData {
    version: number;
    key: Uint8Array;
    user: LoginResponseUser;
    serverUrl: string;
    authToken?: string;
}
export interface AccountDataStored {
    version: number;
    encryptedData: Uint8Array;
}
export declare class Account {
    private mainKey;
    private version;
    user: LoginResponseUser;
    serverUrl: string;
    authToken: string | null;
    private constructor();
    static isEtebaseServer(serverUrl: string): Promise<boolean>;
    static signup(user: User, password: string, serverUrl?: string): Promise<Account>;
    static login(username: string, password: string, serverUrl?: string): Promise<Account>;
    fetchToken(): Promise<void>;
    logout(): Promise<void>;
    changePassword(password: string): Promise<void>;
    getDashboardUrl(): Promise<string>;
    save(encryptionKey_?: Uint8Array): Promise<base64>;
    static restore(accountDataStored_: base64, encryptionKey_?: Uint8Array): Promise<Account>;
    getCollectionManager(): CollectionManager;
    getInvitationManager(): CollectionInvitationManager;
    _getCryptoManager(): import("./EncryptedModels").AccountCryptoManager;
    _getIdentityCryptoManager(): BoxCryptoManager;
}
export declare class CollectionManager {
    private readonly etebase;
    private readonly onlineManager;
    constructor(etebase: Account);
    create(colType: string, meta: ItemMetadata, content: Uint8Array | string): Promise<Collection>;
    fetch(colUid: base64, options?: FetchOptions): Promise<Collection>;
    list(colType: string | string[], options?: FetchOptions): Promise<{
        data: Collection[];
        removedMemberships?: import("./OnlineManagers").RemovedCollection[] | undefined;
        stoken: string;
        done: boolean;
    }>;
    upload(collection: Collection, options?: FetchOptions): Promise<void>;
    transaction(collection: Collection, options?: FetchOptions): Promise<void>;
    cacheSave(collection: Collection, options?: {
        saveContent: boolean;
    }): Uint8Array;
    cacheLoad(cache: Uint8Array): Collection;
    getItemManager(col: Collection): ItemManager;
    getMemberManager(col: Collection): CollectionMemberManager;
}
export declare class ItemManager {
    private readonly collectionCryptoManager;
    private readonly onlineManager;
    private readonly collectionUid;
    constructor(etebase: Account, _collectionManager: CollectionManager, col: EncryptedCollection);
    create(meta: ItemMetadata, content: Uint8Array | string): Promise<Item>;
    fetch(itemUid: base64, options?: ItemFetchOptions): Promise<Item>;
    list(options?: ItemFetchOptions): Promise<{
        data: Item[];
        stoken: string;
        done: boolean;
    }>;
    itemRevisions(item: Item, options?: RevisionsFetchOptions): Promise<{
        data: Item[];
        iterator: string;
        done: boolean;
    }>;
    private itemsPrepareForUpload;
    fetchUpdates(items: Item[], options?: ItemFetchOptions): Promise<{
        data: Item[];
        stoken: string;
        done: boolean;
    }>;
    batch(items: Item[], deps?: Item[] | null, options?: ItemFetchOptions): Promise<void>;
    transaction(items: Item[], deps?: Item[] | null, options?: ItemFetchOptions): Promise<void>;
    preUploadContent(item: Item): Promise<void>;
    downloadMissingContent(item: Item): Promise<void>;
    cacheSave(item: Item, options?: {
        saveContent: boolean;
    }): Uint8Array;
    cacheLoad(cache: Uint8Array): Item;
}
export interface SignedInvitationContent {
    encryptionKey: Uint8Array;
    collectionType: string;
}
export interface SignedInvitation {
    uid: base64;
    version: number;
    username: string;
    collection: base64;
    accessLevel: CollectionAccessLevel;
    signedEncryptionKey: Uint8Array;
    fromUsername?: string;
    fromPubkey: Uint8Array;
}
export declare class CollectionInvitationManager {
    private readonly etebase;
    private readonly onlineManager;
    constructor(etebase: Account);
    listIncoming(options?: InvitationFetchOptions): Promise<import("./OnlineManagers").CollectionInvitationListResponse<import("./EncryptedModels").SignedInvitationRead>>;
    listOutgoing(options?: InvitationFetchOptions): Promise<import("./OnlineManagers").CollectionInvitationListResponse<import("./EncryptedModels").SignedInvitationRead>>;
    accept(invitation: SignedInvitation): Promise<{}>;
    reject(invitation: SignedInvitation): Promise<{}>;
    fetchUserProfile(username: string): Promise<import("./OnlineManagers").UserProfile>;
    invite(col: Collection, username: string, pubkey: Uint8Array, accessLevel: CollectionAccessLevel): Promise<void>;
    disinvite(invitation: SignedInvitation): Promise<{}>;
    get pubkey(): Uint8Array;
}
export declare class CollectionMemberManager {
    private readonly etebase;
    private readonly onlineManager;
    constructor(etebase: Account, _collectionManager: CollectionManager, encryptedCollection: EncryptedCollection);
    list(options?: MemberFetchOptions): Promise<import("./OnlineManagers").CollectionMemberListResponse<import("./OnlineManagers").CollectionMember>>;
    remove(username: string): Promise<{}>;
    leave(): Promise<{}>;
    modifyAccessLevel(username: string, accessLevel: CollectionAccessLevel): Promise<{}>;
}
export declare enum OutputFormat {
    Uint8Array = 0,
    String = 1
}
export declare class Collection {
    private readonly cryptoManager;
    readonly encryptedCollection: EncryptedCollection;
    constructor(cryptoManager: CollectionCryptoManager, encryptedCollection: EncryptedCollection);
    verify(): boolean;
    setMeta(meta: ItemMetadata): void;
    getMeta(): ItemMetadata;
    setContent(content: Uint8Array | string): Promise<void>;
    getContent(outputFormat?: OutputFormat.Uint8Array): Promise<Uint8Array>;
    getContent(outputFormat?: OutputFormat.String): Promise<string>;
    delete(preserveContent?: boolean): void;
    get uid(): string;
    get etag(): string;
    get isDeleted(): boolean;
    get stoken(): string | null;
    get accessLevel(): CollectionAccessLevel;
    getCollectionType(): string;
    get item(): Item;
}
export declare class Item {
    private readonly cryptoManager;
    readonly encryptedItem: EncryptedCollectionItem;
    readonly collectionUid: string;
    constructor(collectionUid: string, cryptoManager: CollectionItemCryptoManager, encryptedItem: EncryptedCollectionItem);
    verify(): boolean;
    setMeta(meta: ItemMetadata): void;
    getMeta(): ItemMetadata;
    setContent(content: Uint8Array | string): Promise<void>;
    getContent(outputFormat?: OutputFormat.Uint8Array): Promise<Uint8Array>;
    getContent(outputFormat?: OutputFormat.String): Promise<string>;
    delete(preserveContent?: boolean): void;
    get uid(): string;
    get etag(): string;
    get isDeleted(): boolean;
    get isMissingContent(): boolean;
    _clone(): Item;
}
