import { ExtensionCodecType } from "./ExtensionCodec";
import { CachedKeyDecoder } from "./CachedKeyDecoder";
declare const enum State {
    ARRAY = 0,
    MAP_KEY = 1,
    MAP_VALUE = 2
}
declare type MapKeyType = string | number;
declare type StackMapState = {
    type: State.MAP_KEY | State.MAP_VALUE;
    size: number;
    key: MapKeyType | null;
    readCount: number;
    map: Record<string, unknown>;
};
declare type StackArrayState = {
    type: State.ARRAY;
    size: number;
    array: Array<unknown>;
    position: number;
};
declare type StackState = StackArrayState | StackMapState;
export declare const DataViewIndexOutOfBoundsError: typeof Error;
export declare class Decoder<ContextType> {
    readonly extensionCodec: ExtensionCodecType<ContextType>;
    readonly context: ContextType;
    readonly maxStrLength: number;
    readonly maxBinLength: number;
    readonly maxArrayLength: number;
    readonly maxMapLength: number;
    readonly maxExtLength: number;
    readonly cachedKeyDecoder: CachedKeyDecoder | null;
    totalPos: number;
    pos: number;
    view: DataView;
    bytes: Uint8Array;
    headByte: number;
    readonly stack: Array<StackState>;
    constructor(extensionCodec: ExtensionCodecType<ContextType>, context: ContextType, maxStrLength?: number, maxBinLength?: number, maxArrayLength?: number, maxMapLength?: number, maxExtLength?: number, cachedKeyDecoder?: CachedKeyDecoder | null);
    setBuffer(buffer: ArrayLike<number> | ArrayBuffer): void;
    appendBuffer(buffer: ArrayLike<number>): void;
    hasRemaining(size?: number): boolean;
    createNoExtraBytesError(posToShow: number): Error;
    decodeSingleSync(): unknown;
    decodeSingleAsync(stream: AsyncIterable<ArrayLike<number>>): Promise<unknown>;
    decodeArrayStream(stream: AsyncIterable<ArrayLike<number>>): AsyncGenerator<unknown, void, unknown>;
    decodeStream(stream: AsyncIterable<ArrayLike<number>>): AsyncGenerator<unknown, void, unknown>;
    private decodeMultiAsync;
    decodeSync(): unknown;
    readHeadByte(): number;
    complete(): void;
    readArraySize(): number;
    pushMapState(size: number): void;
    pushArrayState(size: number): void;
    decodeUtf8String(byteLength: number, headerOffset: number): string;
    stateIsMapKey(): boolean;
    decodeBinary(byteLength: number, headOffset: number): Uint8Array;
    decodeExtension(size: number, headOffset: number): unknown;
    lookU8(): number;
    lookU16(): number;
    lookU32(): number;
    readU8(): number;
    readI8(): number;
    readU16(): number;
    readI16(): number;
    readU32(): number;
    readI32(): number;
    readU64(): number;
    readI64(): number;
    readF32(): number;
    readF64(): number;
}
export {};
