"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const color_string_1 = __importDefault(require("color-string"));
const fs = __importStar(require("fs-extra"));
const lodash_1 = require("lodash");
const path_1 = __importDefault(require("path"));
/**
 * @param value Value to be checked.
 * @param availableValues Object storing all available options as values.
 */
function validateEnumValue(value, availableValues) {
    if (!Object.values(availableValues).includes(value)) {
        throw new Error(`Invalid value '${value}'. Available values are ${Object.values(availableValues)
            .map(v => `"${v}"`)
            .join(' | ')}.`);
    }
    return value;
}
exports.validateEnumValue = validateEnumValue;
/**
 * @param filePath Relative or absolute path to a file.
 * @returns Absolute path to the valid image file.
 */
async function validateFileIsPng(filePath) {
    const resolvedPath = await validateFileExists(filePath);
    // check if resolvedPath is a readable .png file
    if (path_1.default.extname(resolvedPath) !== '.png') {
        throw new Error(`Invalid path '${filePath}' - file is not a .png file. Provide a path to a file with .png extension.`);
    }
    return resolvedPath;
}
exports.validateFileIsPng = validateFileIsPng;
/**
 * @param filePath Relative or absolute path to a file.
 * @returns Absolute path to the resolved file.
 */
async function validateFileExists(filePath) {
    const resolvedPath = path_1.default.resolve(filePath);
    if (!(await fs.pathExists(resolvedPath))) {
        throw new Error(`Invalid path '${filePath}' - file does not exist. Provide a path to an existing file.`);
    }
    return resolvedPath;
}
exports.validateFileExists = validateFileExists;
/**
 * @param value Value to be checked.
 */
function validateColor(value) {
    var _a;
    const result = (_a = color_string_1.default.get(value)) === null || _a === void 0 ? void 0 : _a.value;
    if (!result) {
        throw new Error(`Invalid value '${value}' - value is not a color string. Provide a valid color string.`);
    }
    return result;
}
exports.validateColor = validateColor;
function generateValidateEnumValue(availableValues) {
    return (value) => validateEnumValue(value, availableValues);
}
exports.generateValidateEnumValue = generateValidateEnumValue;
function ensurePropertyExists(object, propertyPath) {
    const value = lodash_1.get(object, propertyPath, undefined);
    if (value === undefined) {
        throw new Error(`Missing a required valid value for '${propertyPath.join('.')}'. Provide a valid value for it to enable this property.`);
    }
}
exports.ensurePropertyExists = ensurePropertyExists;
//# sourceMappingURL=utils.js.map