"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
// @ts-ignore
const glob_1 = require("glob");
const path_1 = __importDefault(require("path"));
const xcode_1 = __importDefault(require("xcode"));
const pbxFile_1 = __importDefault(require("xcode/lib/pbxFile"));
function getProjectName(projectRoot) {
    const sourceRoot = getSourceRoot(projectRoot);
    return path_1.default.basename(sourceRoot);
}
exports.getProjectName = getProjectName;
function getSourceRoot(projectRoot) {
    // Account for Swift or Objective-C
    const paths = glob_1.sync('ios/*/AppDelegate.*', {
        absolute: true,
        cwd: projectRoot,
    });
    if (!paths.length) {
        throw new Error(`Could not locate a valid iOS project at root: ${projectRoot}`);
    }
    return path_1.default.dirname(paths[0]);
}
exports.getSourceRoot = getSourceRoot;
// TODO(brentvatne): I couldn't figure out how to do this with an existing
// higher level function exposed by the xcode library, but we should find out how to do
// that and replace this with it
function addFileToGroup(filepath, groupName, project) {
    const file = new pbxFile_1.default(filepath);
    file.uuid = project.generateUuid();
    file.fileRef = project.generateUuid();
    project.addToPbxFileReferenceSection(file);
    project.addToPbxBuildFileSection(file);
    project.addToPbxSourcesBuildPhase(file);
    const group = pbxGroupByPath(project, groupName);
    if (!group) {
        throw Error(`Group by name ${groupName} not found!`);
    }
    group.children.push({
        value: file.fileRef,
        comment: file.basename,
    });
    return project;
}
exports.addFileToGroup = addFileToGroup;
function splitPath(path) {
    // TODO: Should we account for other platforms that may not use `/`
    return path.split('/');
}
const findGroup = (group, name) => {
    if (!group) {
        return undefined;
    }
    return group.children.find(group => group.comment === name);
};
function findGroupInsideGroup(project, group, name) {
    var _a;
    const foundGroup = findGroup(group, name);
    if (foundGroup) {
        return (_a = project.getPBXGroupByKey(foundGroup.value)) !== null && _a !== void 0 ? _a : null;
    }
    return null;
}
function pbxGroupByPath(project, path) {
    const { firstProject } = project.getFirstProject();
    let group = project.getPBXGroupByKey(firstProject.mainGroup);
    const components = splitPath(path);
    for (const name of components) {
        const nextGroup = findGroupInsideGroup(project, group, name);
        if (nextGroup) {
            group = nextGroup;
        }
        else {
            return null;
        }
    }
    return group !== null && group !== void 0 ? group : null;
}
function ensureGroupRecursively(project, filepath) {
    const components = splitPath(filepath);
    const hasChild = (group, name) => group.children.find(({ comment }) => comment === name);
    const { firstProject } = project.getFirstProject();
    let topMostGroup = project.getPBXGroupByKey(firstProject.mainGroup);
    for (const pathComponent of components) {
        if (topMostGroup && !hasChild(topMostGroup, pathComponent)) {
            topMostGroup.children.push({
                comment: pathComponent,
                value: project.pbxCreateGroup(pathComponent, '""'),
            });
        }
        topMostGroup = project.pbxGroupByName(pathComponent);
    }
    return topMostGroup !== null && topMostGroup !== void 0 ? topMostGroup : null;
}
exports.ensureGroupRecursively = ensureGroupRecursively;
function findSchemeNames(projectRoot) {
    const schemePaths = glob_1.sync('ios/*.xcodeproj/xcshareddata/xcschemes/*.xcscheme', {
        absolute: true,
        cwd: projectRoot,
    });
    return schemePaths.map(schemePath => path_1.default.basename(schemePath).split('.')[0]);
}
exports.findSchemeNames = findSchemeNames;
/**
 * Get the pbxproj for the given path
 */
function getPbxproj(projectRoot) {
    const pbxprojPaths = glob_1.sync('ios/*/project.pbxproj', { absolute: true, cwd: projectRoot });
    const [pbxprojPath, ...otherPbxprojPaths] = pbxprojPaths;
    if (pbxprojPaths.length > 1) {
        console.warn(`Found multiple pbxproject files paths, using ${pbxprojPath}. Other paths ${JSON.stringify(otherPbxprojPaths)} ignored.`);
    }
    const project = xcode_1.default.project(pbxprojPath);
    project.parseSync();
    return project;
}
exports.getPbxproj = getPbxproj;
function getProjectSection(project) {
    return project.pbxProjectSection();
}
exports.getProjectSection = getProjectSection;
function getNativeTargets(project) {
    const section = project.pbxNativeTargetSection();
    return Object.entries(section).filter(isNotComment);
}
exports.getNativeTargets = getNativeTargets;
function findFirstNativeTarget(project) {
    const { targets } = Object.values(getProjectSection(project))[0];
    const target = targets[0].value;
    const nativeTargets = getNativeTargets(project);
    const nativeTarget = nativeTargets.find(([key]) => key === target)[1];
    return nativeTarget;
}
exports.findFirstNativeTarget = findFirstNativeTarget;
function getXCConfigurationListEntries(project) {
    const lists = project.pbxXCConfigurationList();
    return Object.entries(lists).filter(isNotComment);
}
exports.getXCConfigurationListEntries = getXCConfigurationListEntries;
function getBuildConfigurationForId(project, configurationListId) {
    const configurationListEntries = getXCConfigurationListEntries(project);
    const [, configurationList] = configurationListEntries.find(([key]) => key === configurationListId);
    const buildConfigurations = configurationList.buildConfigurations.map(i => i.value);
    return Object.entries(project.pbxXCBuildConfigurationSection())
        .filter(isNotComment)
        .filter(isBuildConfig)
        .filter(isNotTestHost)
        .filter(([key]) => buildConfigurations.includes(key));
}
exports.getBuildConfigurationForId = getBuildConfigurationForId;
function isBuildConfig([, sectionItem]) {
    return sectionItem.isa === 'XCBuildConfiguration';
}
exports.isBuildConfig = isBuildConfig;
function isNotTestHost([, sectionItem]) {
    return !sectionItem.buildSettings.TEST_HOST;
}
exports.isNotTestHost = isNotTestHost;
function isNotComment([key]) {
    return !key.endsWith(`_comment`);
}
exports.isNotComment = isNotComment;
//# sourceMappingURL=Xcodeproj.js.map