"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const fs_extra_1 = __importDefault(require("fs-extra"));
const path_1 = __importDefault(require("path"));
const Scheme_1 = require("./Scheme");
const Xcodeproj_1 = require("./utils/Xcodeproj");
function getGoogleMapsApiKey(config) {
    var _a, _b, _c;
    return (_c = (_b = (_a = config.ios) === null || _a === void 0 ? void 0 : _a.config) === null || _b === void 0 ? void 0 : _b.googleMapsApiKey) !== null && _c !== void 0 ? _c : null;
}
exports.getGoogleMapsApiKey = getGoogleMapsApiKey;
// NOTE(brentvatne): if the developer has installed the google ads sdk and does
// not provide an app id their app will crash. Standalone apps get around this by
// providing some default value, we will instead here assume that the user can
// do the right thing if they have installed the package. This is a slight discrepancy
// that arises in ejecting because it's possible for the package to be installed and
// not crashing in the managed workflow, then you eject and the app crashes because
// you don't have an id to fall back to.
function getGoogleMobileAdsAppId(config) {
    var _a, _b, _c;
    return (_c = (_b = (_a = config.ios) === null || _a === void 0 ? void 0 : _a.config) === null || _b === void 0 ? void 0 : _b.googleMobileAdsAppId) !== null && _c !== void 0 ? _c : null;
}
exports.getGoogleMobileAdsAppId = getGoogleMobileAdsAppId;
function getGoogleSignInReservedClientId(config) {
    var _a, _b, _c, _d;
    return (_d = (_c = (_b = (_a = config.ios) === null || _a === void 0 ? void 0 : _a.config) === null || _b === void 0 ? void 0 : _b.googleSignIn) === null || _c === void 0 ? void 0 : _c.reservedClientId) !== null && _d !== void 0 ? _d : null;
}
exports.getGoogleSignInReservedClientId = getGoogleSignInReservedClientId;
function getGoogleServicesFile(config) {
    var _a, _b;
    return (_b = (_a = config.ios) === null || _a === void 0 ? void 0 : _a.googleServicesFile) !== null && _b !== void 0 ? _b : null;
}
exports.getGoogleServicesFile = getGoogleServicesFile;
function setGoogleMapsApiKey(config, _a) {
    var { GMSApiKey } = _a, infoPlist = __rest(_a, ["GMSApiKey"]);
    const apiKey = getGoogleMapsApiKey(config);
    if (apiKey === null) {
        return infoPlist;
    }
    return Object.assign(Object.assign({}, infoPlist), { GMSApiKey: apiKey });
}
exports.setGoogleMapsApiKey = setGoogleMapsApiKey;
function setGoogleMobileAdsAppId(config, _a) {
    var { GADApplicationIdentifier } = _a, infoPlist = __rest(_a, ["GADApplicationIdentifier"]);
    const appId = getGoogleMobileAdsAppId(config);
    if (appId === null) {
        return infoPlist;
    }
    return Object.assign(Object.assign({}, infoPlist), { GADApplicationIdentifier: appId });
}
exports.setGoogleMobileAdsAppId = setGoogleMobileAdsAppId;
function setGoogleSignInReservedClientId(config, infoPlist) {
    const reservedClientId = getGoogleSignInReservedClientId(config);
    if (reservedClientId === null) {
        return infoPlist;
    }
    return Scheme_1.appendScheme(reservedClientId, infoPlist);
}
exports.setGoogleSignInReservedClientId = setGoogleSignInReservedClientId;
function setGoogleConfig(config, infoPlist) {
    infoPlist = setGoogleMapsApiKey(config, infoPlist);
    infoPlist = setGoogleMobileAdsAppId(config, infoPlist);
    infoPlist = setGoogleSignInReservedClientId(config, infoPlist);
    return infoPlist;
}
exports.setGoogleConfig = setGoogleConfig;
function setGoogleServicesFile(config, projectRoot) {
    const googleServicesFileRelativePath = getGoogleServicesFile(config);
    if (googleServicesFileRelativePath === null) {
        return;
    }
    const googleServiceFilePath = path_1.default.resolve(projectRoot, googleServicesFileRelativePath);
    fs_extra_1.default.copyFileSync(googleServiceFilePath, path_1.default.join(Xcodeproj_1.getSourceRoot(projectRoot), 'GoogleService-Info.plist'));
    let project = Xcodeproj_1.getPbxproj(projectRoot);
    const projectName = Xcodeproj_1.getProjectName(projectRoot);
    project = Xcodeproj_1.addFileToGroup(`${projectName}/GoogleService-Info.plist`, projectName, project);
    fs_extra_1.default.writeFileSync(project.filepath, project.writeSync());
}
exports.setGoogleServicesFile = setGoogleServicesFile;
//# sourceMappingURL=Google.js.map