import { ExpoConfig } from '../Config.types';
import { InfoPlist } from './IosConfig.types';
/**
 * Getters
 * TODO: these getters are the same between ios/android, we could reuse them
 */
export declare function getFacebookScheme(config: ExpoConfig): string | null;
export declare function getFacebookAppId(config: ExpoConfig): string | null;
export declare function getFacebookDisplayName(config: ExpoConfig): string | null;
export declare function getFacebookAutoInitEnabled(config: ExpoConfig): boolean | null;
export declare function getFacebookAutoLogAppEvents(config: ExpoConfig): boolean | null;
export declare function getFacebookAdvertiserIDCollection(config: ExpoConfig): boolean | null;
/**
 * Setters
 */
export declare function setFacebookConfig(config: ExpoConfig, infoPlist: InfoPlist): InfoPlist;
export declare function setFacebookScheme(config: ExpoConfig, infoPlist: InfoPlist): InfoPlist;
export declare function setFacebookAutoInitEnabled(config: ExpoConfig, { FacebookAutoInitEnabled, ...infoPlist }: InfoPlist): {
    CFBundleShortVersionString?: string | undefined;
    CFBundleVersion?: string | undefined;
    CFBundleDisplayName?: string | undefined;
    CFBundleIdentifier?: string | undefined;
    CFBundleName?: string | undefined;
    CFBundleURLTypes?: import("./IosConfig.types").URLScheme[] | undefined;
    ITSAppUsesNonExemptEncryption?: boolean | undefined;
    LSApplicationQueriesSchemes?: string[] | undefined;
    FacebookAppID?: string | undefined;
    FacebookDisplayName?: string | undefined;
    FacebookAutoLogAppEventsEnabled?: boolean | undefined;
    FacebookAdvertiserIDCollectionEnabled?: boolean | undefined;
    UISupportedInterfaceOrientations?: import("./IosConfig.types").InterfaceOrientation[] | undefined;
    GMSApiKey?: string | undefined;
    GADApplicationIdentifier?: string | undefined;
    UIUserInterfaceStyle?: string | undefined;
} | {
    FacebookAutoInitEnabled: boolean;
    CFBundleShortVersionString?: string | undefined;
    CFBundleVersion?: string | undefined;
    CFBundleDisplayName?: string | undefined;
    CFBundleIdentifier?: string | undefined;
    CFBundleName?: string | undefined;
    CFBundleURLTypes?: import("./IosConfig.types").URLScheme[] | undefined;
    ITSAppUsesNonExemptEncryption?: boolean | undefined;
    LSApplicationQueriesSchemes?: string[] | undefined;
    FacebookAppID?: string | undefined;
    FacebookDisplayName?: string | undefined;
    FacebookAutoLogAppEventsEnabled?: boolean | undefined;
    FacebookAdvertiserIDCollectionEnabled?: boolean | undefined;
    UISupportedInterfaceOrientations?: import("./IosConfig.types").InterfaceOrientation[] | undefined;
    GMSApiKey?: string | undefined;
    GADApplicationIdentifier?: string | undefined;
    UIUserInterfaceStyle?: string | undefined;
};
export declare function setFacebookAutoLogAppEventsEnabled(config: ExpoConfig, { FacebookAutoLogAppEventsEnabled, ...infoPlist }: InfoPlist): {
    CFBundleShortVersionString?: string | undefined;
    CFBundleVersion?: string | undefined;
    CFBundleDisplayName?: string | undefined;
    CFBundleIdentifier?: string | undefined;
    CFBundleName?: string | undefined;
    CFBundleURLTypes?: import("./IosConfig.types").URLScheme[] | undefined;
    ITSAppUsesNonExemptEncryption?: boolean | undefined;
    LSApplicationQueriesSchemes?: string[] | undefined;
    FacebookAppID?: string | undefined;
    FacebookDisplayName?: string | undefined;
    FacebookAutoInitEnabled?: boolean | undefined;
    FacebookAdvertiserIDCollectionEnabled?: boolean | undefined;
    UISupportedInterfaceOrientations?: import("./IosConfig.types").InterfaceOrientation[] | undefined;
    GMSApiKey?: string | undefined;
    GADApplicationIdentifier?: string | undefined;
    UIUserInterfaceStyle?: string | undefined;
} | {
    FacebookAutoLogAppEventsEnabled: boolean;
    CFBundleShortVersionString?: string | undefined;
    CFBundleVersion?: string | undefined;
    CFBundleDisplayName?: string | undefined;
    CFBundleIdentifier?: string | undefined;
    CFBundleName?: string | undefined;
    CFBundleURLTypes?: import("./IosConfig.types").URLScheme[] | undefined;
    ITSAppUsesNonExemptEncryption?: boolean | undefined;
    LSApplicationQueriesSchemes?: string[] | undefined;
    FacebookAppID?: string | undefined;
    FacebookDisplayName?: string | undefined;
    FacebookAutoInitEnabled?: boolean | undefined;
    FacebookAdvertiserIDCollectionEnabled?: boolean | undefined;
    UISupportedInterfaceOrientations?: import("./IosConfig.types").InterfaceOrientation[] | undefined;
    GMSApiKey?: string | undefined;
    GADApplicationIdentifier?: string | undefined;
    UIUserInterfaceStyle?: string | undefined;
};
export declare function setFacebookAdvertiserIDCollectionEnabled(config: ExpoConfig, { FacebookAdvertiserIDCollectionEnabled, ...infoPlist }: InfoPlist): {
    CFBundleShortVersionString?: string | undefined;
    CFBundleVersion?: string | undefined;
    CFBundleDisplayName?: string | undefined;
    CFBundleIdentifier?: string | undefined;
    CFBundleName?: string | undefined;
    CFBundleURLTypes?: import("./IosConfig.types").URLScheme[] | undefined;
    ITSAppUsesNonExemptEncryption?: boolean | undefined;
    LSApplicationQueriesSchemes?: string[] | undefined;
    FacebookAppID?: string | undefined;
    FacebookDisplayName?: string | undefined;
    FacebookAutoInitEnabled?: boolean | undefined;
    FacebookAutoLogAppEventsEnabled?: boolean | undefined;
    UISupportedInterfaceOrientations?: import("./IosConfig.types").InterfaceOrientation[] | undefined;
    GMSApiKey?: string | undefined;
    GADApplicationIdentifier?: string | undefined;
    UIUserInterfaceStyle?: string | undefined;
} | {
    FacebookAdvertiserIDCollectionEnabled: boolean;
    CFBundleShortVersionString?: string | undefined;
    CFBundleVersion?: string | undefined;
    CFBundleDisplayName?: string | undefined;
    CFBundleIdentifier?: string | undefined;
    CFBundleName?: string | undefined;
    CFBundleURLTypes?: import("./IosConfig.types").URLScheme[] | undefined;
    ITSAppUsesNonExemptEncryption?: boolean | undefined;
    LSApplicationQueriesSchemes?: string[] | undefined;
    FacebookAppID?: string | undefined;
    FacebookDisplayName?: string | undefined;
    FacebookAutoInitEnabled?: boolean | undefined;
    FacebookAutoLogAppEventsEnabled?: boolean | undefined;
    UISupportedInterfaceOrientations?: import("./IosConfig.types").InterfaceOrientation[] | undefined;
    GMSApiKey?: string | undefined;
    GADApplicationIdentifier?: string | undefined;
    UIUserInterfaceStyle?: string | undefined;
};
export declare function setFacebookAppId(config: ExpoConfig, { FacebookAppID, ...infoPlist }: InfoPlist): {
    CFBundleShortVersionString?: string | undefined;
    CFBundleVersion?: string | undefined;
    CFBundleDisplayName?: string | undefined;
    CFBundleIdentifier?: string | undefined;
    CFBundleName?: string | undefined;
    CFBundleURLTypes?: import("./IosConfig.types").URLScheme[] | undefined;
    ITSAppUsesNonExemptEncryption?: boolean | undefined;
    LSApplicationQueriesSchemes?: string[] | undefined;
    FacebookDisplayName?: string | undefined;
    FacebookAutoInitEnabled?: boolean | undefined;
    FacebookAutoLogAppEventsEnabled?: boolean | undefined;
    FacebookAdvertiserIDCollectionEnabled?: boolean | undefined;
    UISupportedInterfaceOrientations?: import("./IosConfig.types").InterfaceOrientation[] | undefined;
    GMSApiKey?: string | undefined;
    GADApplicationIdentifier?: string | undefined;
    UIUserInterfaceStyle?: string | undefined;
} | {
    FacebookAppID: string;
    CFBundleShortVersionString?: string | undefined;
    CFBundleVersion?: string | undefined;
    CFBundleDisplayName?: string | undefined;
    CFBundleIdentifier?: string | undefined;
    CFBundleName?: string | undefined;
    CFBundleURLTypes?: import("./IosConfig.types").URLScheme[] | undefined;
    ITSAppUsesNonExemptEncryption?: boolean | undefined;
    LSApplicationQueriesSchemes?: string[] | undefined;
    FacebookDisplayName?: string | undefined;
    FacebookAutoInitEnabled?: boolean | undefined;
    FacebookAutoLogAppEventsEnabled?: boolean | undefined;
    FacebookAdvertiserIDCollectionEnabled?: boolean | undefined;
    UISupportedInterfaceOrientations?: import("./IosConfig.types").InterfaceOrientation[] | undefined;
    GMSApiKey?: string | undefined;
    GADApplicationIdentifier?: string | undefined;
    UIUserInterfaceStyle?: string | undefined;
};
export declare function setFacebookDisplayName(config: ExpoConfig, { FacebookDisplayName, ...infoPlist }: InfoPlist): {
    CFBundleShortVersionString?: string | undefined;
    CFBundleVersion?: string | undefined;
    CFBundleDisplayName?: string | undefined;
    CFBundleIdentifier?: string | undefined;
    CFBundleName?: string | undefined;
    CFBundleURLTypes?: import("./IosConfig.types").URLScheme[] | undefined;
    ITSAppUsesNonExemptEncryption?: boolean | undefined;
    LSApplicationQueriesSchemes?: string[] | undefined;
    FacebookAppID?: string | undefined;
    FacebookAutoInitEnabled?: boolean | undefined;
    FacebookAutoLogAppEventsEnabled?: boolean | undefined;
    FacebookAdvertiserIDCollectionEnabled?: boolean | undefined;
    UISupportedInterfaceOrientations?: import("./IosConfig.types").InterfaceOrientation[] | undefined;
    GMSApiKey?: string | undefined;
    GADApplicationIdentifier?: string | undefined;
    UIUserInterfaceStyle?: string | undefined;
} | {
    FacebookDisplayName: string;
    CFBundleShortVersionString?: string | undefined;
    CFBundleVersion?: string | undefined;
    CFBundleDisplayName?: string | undefined;
    CFBundleIdentifier?: string | undefined;
    CFBundleName?: string | undefined;
    CFBundleURLTypes?: import("./IosConfig.types").URLScheme[] | undefined;
    ITSAppUsesNonExemptEncryption?: boolean | undefined;
    LSApplicationQueriesSchemes?: string[] | undefined;
    FacebookAppID?: string | undefined;
    FacebookAutoInitEnabled?: boolean | undefined;
    FacebookAutoLogAppEventsEnabled?: boolean | undefined;
    FacebookAdvertiserIDCollectionEnabled?: boolean | undefined;
    UISupportedInterfaceOrientations?: import("./IosConfig.types").InterfaceOrientation[] | undefined;
    GMSApiKey?: string | undefined;
    GADApplicationIdentifier?: string | undefined;
    UIUserInterfaceStyle?: string | undefined;
};
export declare function setFacebookApplicationQuerySchemes(config: ExpoConfig, infoPlist: InfoPlist): InfoPlist;
