"use strict";
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const fs = __importStar(require("fs-extra"));
const Xcodeproj_1 = require("./utils/Xcodeproj");
function getSupportsTablet(config) {
    var _a, _b;
    if ((_a = config.ios) === null || _a === void 0 ? void 0 : _a.supportsTablet) {
        return !!((_b = config.ios) === null || _b === void 0 ? void 0 : _b.supportsTablet);
    }
    return false;
}
exports.getSupportsTablet = getSupportsTablet;
function getIsTabletOnly(config) {
    var _a;
    if ((_a = config.ios) === null || _a === void 0 ? void 0 : _a.isTabletOnly) {
        return !!config.ios.isTabletOnly;
    }
    return false;
}
exports.getIsTabletOnly = getIsTabletOnly;
function getDeviceFamilies(config) {
    const supportsTablet = getSupportsTablet(config);
    const isTabletOnly = getIsTabletOnly(config);
    // 1 is iPhone, 2 is iPad
    if (isTabletOnly) {
        return [2];
    }
    else if (supportsTablet) {
        return [1, 2];
    }
    else {
        return [1];
    }
}
exports.getDeviceFamilies = getDeviceFamilies;
/**
 * Wrapping the families in double quotes is the only way to set a value with a comma in it.
 * Use a number when only value is returned, this better emulates Xcode.
 *
 * @param deviceFamilies
 */
function formatDeviceFamilies(deviceFamilies) {
    return deviceFamilies.length === 1 ? deviceFamilies[0] : `"${deviceFamilies.join(',')}"`;
}
exports.formatDeviceFamilies = formatDeviceFamilies;
/**
 * Add to pbxproj under TARGETED_DEVICE_FAMILY
 */
function setDeviceFamily(config, projectRoot) {
    const deviceFamilies = formatDeviceFamilies(getDeviceFamilies(config));
    const project = Xcodeproj_1.getPbxproj(projectRoot);
    const configurations = project.pbxXCBuildConfigurationSection();
    // @ts-ignore
    for (const { buildSettings } of Object.values(configurations || {})) {
        // Guessing that this is the best way to emulate Xcode.
        // Using `project.addToBuildSettings` modifies too many targets.
        if (typeof (buildSettings === null || buildSettings === void 0 ? void 0 : buildSettings.PRODUCT_NAME) !== 'undefined') {
            buildSettings.TARGETED_DEVICE_FAMILY = deviceFamilies;
        }
    }
    fs.writeFileSync(project.filepath, project.writeSync());
}
exports.setDeviceFamily = setDeviceFamily;
//# sourceMappingURL=DeviceFamily.js.map