"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const DEFAULT_VERSION_NAME = '1.0';
const DEFAULT_VERSION_CODE = '1';
function getVersionName(config) {
    var _a;
    return (_a = config.version) !== null && _a !== void 0 ? _a : null;
}
exports.getVersionName = getVersionName;
function setVersionName(config, buildGradle, versionToReplace = DEFAULT_VERSION_NAME) {
    const versionName = getVersionName(config);
    if (versionName === null) {
        return buildGradle;
    }
    const pattern = new RegExp(`versionName "${versionToReplace}"`);
    return buildGradle.replace(pattern, `versionName "${versionName}"`);
}
exports.setVersionName = setVersionName;
function getVersionCode(config) {
    var _a;
    return ((_a = config.android) === null || _a === void 0 ? void 0 : _a.versionCode) ? config.android.versionCode : null;
}
exports.getVersionCode = getVersionCode;
function setVersionCode(config, buildGradle, versionCodeToReplace = DEFAULT_VERSION_CODE) {
    const versionCode = getVersionCode(config);
    if (versionCode === null) {
        return buildGradle;
    }
    const pattern = new RegExp(`versionCode ${versionCodeToReplace}`);
    return buildGradle.replace(pattern, `versionCode ${versionCode}`);
}
exports.setVersionCode = setVersionCode;
//# sourceMappingURL=Version.js.map