"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const Manifest_1 = require("./Manifest");
exports.CONFIG_CHANGES_ATTRIBUTE = 'android:configChanges';
exports.ON_CONFIGURATION_CHANGED = `
public class MainActivity extends ReactActivity {

    // Added automatically by Expo Config
    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        Intent intent = new Intent("onConfigurationChanged");
        intent.putExtra("newConfig", newConfig);
        sendBroadcast(intent);
    }
`;
function getUserInterfaceStyle(config) {
    var _a, _b, _c;
    return (_c = (_b = (_a = config.android) === null || _a === void 0 ? void 0 : _a.userInterfaceStyle) !== null && _b !== void 0 ? _b : config.userInterfaceStyle) !== null && _c !== void 0 ? _c : null;
}
exports.getUserInterfaceStyle = getUserInterfaceStyle;
async function setUiModeAndroidManifest(config, manifestDocument) {
    const userInterfaceStyle = getUserInterfaceStyle(config);
    if (!userInterfaceStyle) {
        return manifestDocument;
    }
    let mainActivity = Manifest_1.getMainActivity(manifestDocument);
    if (!mainActivity) {
        mainActivity = { $: { 'android:name': '.MainActivity' } };
    }
    mainActivity['$'][exports.CONFIG_CHANGES_ATTRIBUTE] =
        'keyboard|keyboardHidden|orientation|screenSize|uiMode';
    return manifestDocument;
}
exports.setUiModeAndroidManifest = setUiModeAndroidManifest;
function addOnConfigurationChangedMainActivity(config, MainActivity) {
    var _a;
    const userInterfaceStyle = getUserInterfaceStyle(config);
    if (!userInterfaceStyle) {
        return MainActivity;
    }
    // Cruzan: this is not ideal, but I'm not sure of a better way to handle writing to MainActivity.java
    if ((_a = MainActivity.match(`onConfigurationChanged`)) === null || _a === void 0 ? void 0 : _a.length) {
        return MainActivity;
    }
    const MainActivityWithImports = addJavaImports(MainActivity, [
        'android.content.Intent',
        'android.content.res.Configuration',
    ]);
    const pattern = new RegExp(`public class MainActivity extends ReactActivity {`);
    return MainActivityWithImports.replace(pattern, exports.ON_CONFIGURATION_CHANGED);
}
exports.addOnConfigurationChangedMainActivity = addOnConfigurationChangedMainActivity;
// TODO: we should have a generic utility for doing this
function addJavaImports(javaSource, javaImports) {
    const lines = javaSource.split('\n');
    const lineIndexWithPackageDeclaration = lines.findIndex(line => line.match(/^package .*;$/));
    for (const javaImport of javaImports) {
        if (!javaSource.includes(javaImport)) {
            const importStatement = `import ${javaImport};`;
            lines.splice(lineIndexWithPackageDeclaration + 1, 0, importStatement);
        }
    }
    return lines.join('\n');
}
//# sourceMappingURL=UserInterfaceStyle.js.map